#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"
#include "rtos.h"

DigitalOut myled(LED1);

int main() {
    EthernetInterface eth;
    int retEth;
    HTTPClient http;
    int rethttp;
    //EthernetInterface eth;
    //HTTPClient http;
    char str[512];
    
    
    printf("Setting up ...\r\n");
    //ネットワークの初期設定DCHPを利用してネットワークを自動で設定している
    eth.init();
    retEth = eth.connect();
    
    //ネットワークの状況をprintfで表示
    if(!retEth)
    {
        printf("Network Setup OK\r\n");
            //POSTメソッドでstewgateにDataを送信
        //POST data
        HTTPMap map;
        HTTPText inText(str, 512);
        map.put("_t","your_token");
        map.put("msg","Tweet from mbed!! using stewgate");
        printf("\nTrying to post data...\n");
        rethttp = http.post("http://stewgate-u.appspot.com/api/post/", map, &inText);
        if (!rethttp)
        {
            printf("Executed POST successfully - read %d characters\n", strlen(str));
            printf("Result: %s\n", str);
        }
        else
        {
            printf("Error - ret = %d - HTTP return code = %d\n", rethttp,http.getHTTPResponseCode());
        }
    }
    else
    {
        printf("Network Error %d\r\n",retEth);
        
    }
    


    eth.disconnect();  
 
    while(1) {
        myled=0;
        wait(0.5);
        myled=1;
    }

}
