#include "mbed.h"
#include "ADT7410.h"
#include "LPS331.h"
#include <stdio.h>
#include <stdlib.h>

#define AQM0802_ADDR    0x7c
#define CMD 0x00
#define DAT 0x40

DigitalOut myled(LED1);
DigitalOut myled2(p29);
I2C i2c(p28, p27);

void LocateLCD(int x, int y)
{

    // 8x2
    char cmd[2];
    cmd[0]=CMD;
    cmd[1]=0x80 + y*0x40 + x;
    i2c.write(AQM0802_ADDR,cmd,2);

}

void PutsLCD(char *buffer)
{

    while(*buffer != '\0')
    {
        char cmd[2];
        cmd[0]=DAT;
        cmd[1]=*buffer;
        i2c.write(AQM0802_ADDR,cmd,2);
        buffer++;
    }

}


int main() {

    char msg[10];
    int temp;
    int l;
    long press;
    char cmd[2];
    char recv[10];

    // set 16bit resolution of ADT7410
    
    cmd[0] = ADT7410_CONFIG;
    cmd[1] = 0xC0;
    i2c.write(ADT7410_ADDR,cmd,2);
    
    // Power ON Cycle=1Hz of LPS331
    cmd[0]=LPS331_CTRL_REG1;
    cmd[1]=0x90;
    i2c.write(LPS331_ADDR,cmd,2);
    
    //init LCD
    // Wait 40ms
    wait_ms(40);
    // Function set = 0x38
    cmd[0]=CMD;
    cmd[1]=0x38;
    i2c.write(AQM0802_ADDR,cmd,2);
    // Wait 26.3us
    wait_us(26.3);
    // Function set = 0x39
    cmd[0]=CMD;
    cmd[1]=0x39;
    i2c.write(AQM0802_ADDR,cmd,2);
    // Wait 26.3us
    wait_us(26.3);
    // Internal OSC frequency = 0x14
    cmd[0]=CMD;
    cmd[1]=0x14;
    i2c.write(AQM0802_ADDR,cmd,2);
    // Wait 26.3us
    wait_us(26.3);
    // Contrast set = 0x70
    cmd[0]=CMD;
    cmd[1]=0x70;
    i2c.write(AQM0802_ADDR,cmd,2);
    // Wait 26.3us
    wait_us(26.3);
    // Power/ICON/Contrast control = 0x56
    cmd[0]=CMD;
    cmd[1]=0x56;
    i2c.write(AQM0802_ADDR,cmd,2);
    // Wait 26.3us
    wait_us(26.3);
    // Follower control = 0x6C
    cmd[0]=CMD;
    cmd[1]=0x6C;
    i2c.write(AQM0802_ADDR,cmd,2);
    // Wait 200ms
    wait_ms(200);
    // Function set = 0x38
    cmd[1]=0x38;
    i2c.write(AQM0802_ADDR,cmd,2);
    // Wait 26.3us
    wait_us(26.3);
    // Display ON/OFF control = 0x0C
    cmd[1]=0x0C;
    i2c.write(AQM0802_ADDR,cmd,2);
    // Wait 26.3us
    wait_us(26.3);
    // Clear Display = 0x01
    cmd[1]=0x01;
    i2c.write( AQM0802_ADDR,cmd,1);
    // Wait 1.08ms
    wait_ms(1.08);

#define PCF8591_ADDR 0x92
#define M24LC64_ADDR 0xA0
#define EEPROM
#define ADC
#define TEMP
#define BAR

    while(1)
    {


#ifdef EEPROM
        
        // Clear Display = 0x01
        cmd[0]=CMD;
        cmd[1]=0x01;
        i2c.write(AQM0802_ADDR,cmd,2);
        // Wait 2ms
        wait_ms(2);
        // EEPROM 0x0002=0x5A
        char EEPROM_CMD[3];
        EEPROM_CMD[0]=0x00;
        EEPROM_CMD[1]=0x02;
        EEPROM_CMD[2]=0x5A;
        i2c.write(M24LC64_ADDR,EEPROM_CMD,3);
        wait_us(131.5);

        //for(l=0;l<0x1FFF;l++){
        for(l=0;l<0x10;l++){
            // EEPROM for 24LC64
            EEPROM_CMD[0]=l>>8;
            EEPROM_CMD[1]=l&0xFF;
            i2c.write(M24LC64_ADDR,EEPROM_CMD,2);
            i2c.read(M24LC64_ADDR,EEPROM_CMD,1);
            temp=EEPROM_CMD[0];
            LocateLCD(0,0);
            PutsLCD("ADR=");
            //itoa(l,msg,16);
            sprintf(msg,"%x",l);
            PutsLCD(msg);
            LocateLCD(0,1);
            PutsLCD("DAT=");
            //itoa(temp,msg,16);
            sprintf(msg,"%x",temp);
            PutsLCD(msg);
            PutsLCD(" ");
            myled2=1;
            wait_ms(100);
            myled2=0;
            wait_ms(1000);
        }
#endif


#ifdef ADC
        // Clear Display = 0x01
        cmd[0]=CMD;
        cmd[1]=0x01;
        i2c.write(AQM0802_ADDR,cmd,2);
        // Wait 2ms
        wait_ms(2);
        // A/D for PCF8591
        //GetI2C(0x40, PCF8591_ADDR); // ch0 with D/A enable
        cmd[0]=0x40;
        i2c.write(PCF8591_ADDR,cmd,1);
        i2c.read(PCF8591_ADDR,cmd,1);
//      GetI2C(0x01, PCF8591_ADDR); // ch1
//      GetI2C(0x02, PCF8591_ADDR); // ch2
//      GetI2C(0x03, PCF8591_ADDR); // ch3
        temp=cmd[0];
        //itoa(temp,msg,10);
        sprintf(msg,"%d",temp);
        LocateLCD(0,0);
        PutsLCD("A/D=");
        PutsLCD(msg);
        PutsLCD("    ");
        myled2=1;
        // D/A for PCF8591
        //PutI2C(0x40, temp, PCF8591_ADDR);
        cmd[0]=0x40;
        cmd[1]=temp;
        i2c.write(PCF8591_ADDR,cmd,2);
        wait_ms(1000);
        myled2=0;
        wait_ms(1000);
#endif

#ifdef TEMP
        // Temperature
        // RDY?
        // Clear Display = 0x01
        cmd[0]=CMD;
        cmd[1]=0x01;
        i2c.write(AQM0802_ADDR,cmd,2);
        // Wait 2ms
        wait_ms(2);
        do{
            //GetI2C(ADT7410_STATUS, ADT7410_ADDR);
            
            cmd[0]=ADT7410_STATUS;
            
            i2c.write(ADT7410_ADDR, cmd,1);
            i2c.read(ADT7410_ADDR, recv,1);
            temp=recv[0];
        }while(temp & 0x80);

        // get temp_high
        cmd[0]=ADT7410_TEMP_H;
        i2c.write(ADT7410_ADDR,cmd,1);
        i2c.read(ADT7410_ADDR,recv,1);
        temp=recv[0]*0x100;
        // get temp_low
        cmd[0]=ADT7410_TEMP_L;
        i2c.write(ADT7410_ADDR,cmd,1);
        i2c.read(ADT7410_ADDR,recv,1);
        temp+=recv[0];
//      temp/=128;  // for C
        temp/=13;
        //itoa(temp,msg,10);
        sprintf(msg,"%d",temp);
        l=strlen(msg);
        msg[l]=msg[l-1];
        msg[l-1]='.';
        msg[l+1]=0;
        LocateLCD(0,0);
        PutsLCD(msg);
        PutsLCD("C   ");
        myled2=1;
        wait_ms(1000);
#endif

#ifdef BAR
        // Barometer
        // get press_high
        cmd[0]=LPS331_PRESS_OUT_H;
        i2c.write(LPS331_ADDR,cmd,1);
        i2c.read(LPS331_ADDR,recv,1);
        press=recv[0]*0x10000;
        // get tpress_low
        cmd[0]=LPS331_PRESS_OUT_L;
        i2c.write(LPS331_ADDR,cmd,1);
        i2c.read(LPS331_ADDR,recv,1);
        press+=recv[0]*0x100;
        // get press_xl
        cmd[0]=LPS331_PRESS_POUT_XL_REH;
        i2c.write(LPS331_ADDR,cmd,1);
        i2c.read(LPS331_ADDR,recv,1);
        press+=recv[0];
//      press/=4096;    // for hPa
        press/=41;
        //itoa(press,msg,10);
        sprintf(msg,"%d",press);
        LocateLCD(0,1);
        PutsLCD(msg);
        PutsLCD("Pa ");
        myled2=0;
        wait_ms(1000);
#endif

    }

}

