#include "mbed.h"
//#define     USE_TextLCD_20x4
#define     USE_FIXED_IP

////////////////////////////////////////
////////    For Waveplayer      ////////
////////////////////////////////////////
//Place suitable uncompressed wav files with 8 or 16 bit sample sizes on the SD card and ensure the
//file names are 8.3 format.  Then change the main method below to the relevant file paths.
#include "wavplayer.h"


////////////////////////////////////////
////////    general setting     ////////
////////////////////////////////////////
//#define     USE_TextLCD_20x4
#define     USE_FIXED_IP

////////////////////////////////////////
////////    For TextLCD         ////////
////////////////////////////////////////
#include "TextLCD.h"
#ifdef  USE_TextLCD_20x4
//TextLCD     lcd( p24, p26, p27, p28, p29, p30, TextLCD::LCD20x4 ); // rs, e, d0-d3
#else
TextLCD     lcd( p24, p26, p27, p28, p29, p30 ); // rs, e, d0-d3
#endif

////////////////////////////////////////
////////    For SD_card         ////////
////////////////////////////////////////
#include "SDHCFileSystem.h"
//SDFileSystem    sd(p5, p6, p7, p13, "sd");  //  mosi, miso, sclk, cs, name
SDFileSystem  sd(p5, p6, p7, p8,  "sd");  //  mosi, miso, sclk, cs, name  (HW modification candidate)

////////////////////////////////////////
////////    For USB storage     ////////
////////////////////////////////////////
//#include "MSCFileSystem.h"
//MSCFileSystem   usb("usb");

////////////////////////////////////////
////////    For Ethernet test   ////////
////////////////////////////////////////
#include "EthernetNetIf.h"
//#include "HTTPServer.h"
//#ifdef      USE_FIXED_IP
//EthernetNetIf   eth(
//    IpAddr(192,168,0,20), //IP Address
//    IpAddr(255,255,255,0), //Network Mask
//    IpAddr(192,168,0,1), //Gateway
//    IpAddr(192,168,0,1)  //DNS
//);
//#else
    EthernetNetIf   eth;
//#endif
//HTTPServer svr;
//#include "HTTPClient.h"
#include "NTPClient.h"
NTPClient ntp;
const char ntp_server[]  = "0.uk.pool.ntp.org";

LocalFileSystem web("local");




void test_file_write( char *title, char *path );
//void test_httpserver( void );
int  position( void );

 DigitalOut led1(LED1);
 DigitalOut led4(LED4);
 
 DigitalIn SW1(p25);
 DigitalIn SW2(p26);
 int TGSW=1;
 DigitalIn SW3(p14);
 DigitalOut AMPEnable(p12);  //0:Off, 1:On
 Serial pc(USBTX, USBRX); // tx, rx
 
 int playflg;
 int playflg2;
 int timest;

char *wavefilename1;
char *wavefilename2;
char *wavefilename3;
char *wavefilename4;

Ticker rt;
char buf[40];
time_t ctTime;

void timecall()
{
     if(TGSW==1)ctTime = time(NULL)+32400;//JST time
     else ctTime = time(NULL);
     strftime(buf,sizeof(buf), " (%Y/%m/%d %a %p %I:%M:%S)", localtime(&ctTime));
     lcd.cls();
     lcd.printf("%s",buf);
}


int main() {
   WavPlayer myWavPlayer;
   SW1.mode(PullUp);
   SW2.mode(PullUp);
   led1 = 1 ;
   playflg = 0;
   playflg2 = 0;
   pc.printf("\r\n--------------- Starting -----------------\r\n");
    lcd.printf("----Starting----");
    lcd.locate(0,1);
    wait(3);
    test_file_write( "SD card", "/sd/star_bd.txt" );
    wait(2);
    //test_file_write( "USB storage", "/usb/star_bd.txt" );
    //wait( 2 );
    AMPEnable=0;
     myWavPlayer.play_wave("/sd/startup.wav");
     wait(0.5);
     myWavPlayer.play_wave("/sd/startup2.wav");
    lcd.cls();
    AMPEnable=0;
    pc.printf("\r\nSetting up...\r\n");
 
    lcd.printf("Setting up...\n");
    if(TGSW==1)
    {
        EthernetErr ethErr = eth.setup();
        if (ethErr) {
        pc.printf("Error %d in setup.\n", ethErr);
        lcd.printf("Error %d in setup.\n", ethErr);
        return -1;
        }
    }
    lcd.locate(0,1);
    pc.printf("\r\nSetup OK\r\n");
    wait(1);
    //test_httpserver();
   
    //RTC setup
    Host server(IpAddr(), 123, ntp_server);
    ntp.setTime(server);
    timest=1;
   
    lcd.cls();
    lcd.printf("Time Set End");
    wait(1);
    
   // rt.attach_us(&timecall,300.0);
    
    while(1)
    {
        lcd.cls();
        ctTime = time(NULL)+32400;//JST time
        strftime(buf,sizeof(buf), " (%Y/%m/%d %a %p %I:%M:%S)", localtime(&ctTime));
        lcd.printf("%s",buf);
        
        //wait(0.5);
        
       if(SW1==0) 
       { 
        if(buf[20]=='1')
        {
            if(buf[21]=='0') wavefilename1 = "/sd/10ji.wav";
            else if(buf[21]=='1') wavefilename1 = "/sd/11ji.wav";
            else if(buf[21]=='2') wavefilename1 = "/sd/12ji.wav";
            else wavefilename1 = "/sd/jikanga.wav";
        }
        else
        {
            if(buf[20]=='0') 
            {
               if(buf[21]=='1') wavefilename1 = "/sd/1ji.wav";
               if(buf[21]=='2') wavefilename1 = "/sd/2ji.wav";
               if(buf[21]=='3') wavefilename1 = "/sd/3ji.wav";
               if(buf[21]=='4') wavefilename1 = "/sd/4ji.wav";
               if(buf[21]=='5') wavefilename1 = "/sd/5ji.wav";
               if(buf[21]=='6') wavefilename1 = "/sd/6ji.wav"; 
               if(buf[21]=='7') wavefilename1 = "/sd/7ji.wav";
               if(buf[21]=='8') wavefilename1 = "/sd/8ji.wav";
               if(buf[21]=='9') wavefilename1 = "/sd/9ji.wav";
            }
            else
            {
                wavefilename1 = "/sd/jikanga.wav";
            }
        } 
                
       if(buf[23]=='0') 
       {
        wavefilename3 = "/sd/desu.wav";
        if(buf[24]=='0') wavefilename2 = "/sd/just.wav";
        else if(buf[24]=='1') wavefilename2 = "/sd/1min.wav";
        else if(buf[24]=='2') wavefilename2 = "/sd/2min.wav";
        else if(buf[24]=='3') wavefilename2 = "/sd/3min.wav";
        else if(buf[24]=='4') wavefilename2 = "/sd/4min.wav";
        else if(buf[24]=='5') wavefilename2 = "/sd/5min.wav";
        else if(buf[24]=='6') wavefilename2 = "/sd/6min.wav";
        else if(buf[24]=='7') wavefilename2 = "/sd/7min.wav";
        else if(buf[24]=='8') wavefilename2 = "/sd/8min.wav";
        else if(buf[24]=='9') wavefilename2 = "/sd/9min.wav";
        else wavefilename2 = "/sd/oksi.wav";
       }
       else if(buf[23]=='1') 
       {
        if(buf[24]=='0'){
         wavefilename2 = "/sd/10min.wav";
         wavefilename3 = "/sd/desu.wav";
        }
        else{
            wavefilename2 = "/sd/10.wav";
            playflg2=1;
            wavefilename4 = "/sd/desu.wav";
        }
       }
       else if(buf[23]=='2') 
       {
        if(buf[24]=='0'){
         wavefilename2 = "/sd/20min.wav";
         wavefilename3 = "/sd/desu.wav";
        }
        else{
            wavefilename2 = "/sd/20.wav";
            playflg2=1;
            wavefilename4 = "/sd/desu.wav";
        }
       }
       else if(buf[23]=='3') 
       {
        if(buf[24]=='0'){
         wavefilename2 = "/sd/30min.wav";
         wavefilename3 = "/sd/desu.wav";
        }
        else{
            wavefilename2 = "/sd/30.wav";
            playflg2=1;
            wavefilename4 = "/sd/desu.wav";
        }
       }
       else if(buf[23]=='4') 
       {
        if(buf[24]=='0'){
         wavefilename2 = "/sd/40min.wav";
         wavefilename3 = "/sd/desu.wav";
        }
        else{
            wavefilename2 = "/sd/40.wav";
            playflg2=1;
            wavefilename4 = "/sd/desu.wav";
        }
       }
       else if(buf[23]=='5') 
       {
        if(buf[24]=='0'){
         wavefilename2 = "/sd/50min.wav";
         wavefilename3 = "/sd/desu.wav";
        }
        else{
            wavefilename2 = "/sd/50.wav";
            playflg2=1;
            wavefilename4 = "/sd/desu.wav";
        }
       }
       else
       {
        wavefilename2 = "/sd/okasi.wav";
        wavefilename3 = "/sd/desu.wav";
       }
      
       if(playflg2==1)
       {
        if(buf[24]=='1') wavefilename3 = "/sd/1min.wav";
        else if(buf[24]=='2') wavefilename3 = "/sd/2min.wav";
        else if(buf[24]=='3') wavefilename3 = "/sd/3min.wav";
        else if(buf[24]=='4') wavefilename3 = "/sd/4min.wav";
        else if(buf[24]=='5') wavefilename3 = "/sd/5min.wav";
        else if(buf[24]=='6') wavefilename3 = "/sd/6min.wav";
        else if(buf[24]=='7') wavefilename3 = "/sd/7min.wav";
        else if(buf[24]=='8') wavefilename3 = "/sd/8min.wav";
        else if(buf[24]=='9') wavefilename3 = "/sd/9min.wav";
       }
              
       playflg=1; 
      }  
       
        
        if(playflg==1)
        {
            lcd.cls();
            lcd.printf("%s", buf);
            AMPEnable=0;
            myWavPlayer.play_wave(wavefilename1); //  8 bit sample size
            myWavPlayer.play_wave(wavefilename2);
            myWavPlayer.play_wave(wavefilename3);
            if(playflg2==1)
            {
                myWavPlayer.play_wave(wavefilename4);
            }
            AMPEnable=1;
            led1 = 0;
            led4 = 1;
        }
        if(SW2==0)
        {
            AMPEnable=0;
            myWavPlayer.play_wave("/sd/doubler.wav");
            AMPEnable=0;
        }
        
        wait(0.2);
        led4 = 0;
        led1 = 1;
        playflg =0;
        playflg2=0;
      
      }
      
}


void test_file_write( char *title, char *path ) {
    //  SD card test
    lcd.locate( 0, position() );
    lcd.printf( "%s: ", title );

    FILE *fp = fopen( path, "w" );
    if ( fp == NULL ) {
        lcd.printf( "error" );
        error( "Could not open file for write\n" );
    }
    fprintf( fp, "The mbed writing a file through the star board orange (%s)!", title );
    fclose( fp );

    lcd.printf( "OK." );
}


int position( void ) {
    static int  p   = 0;

#ifdef  USE_TextLCD_20x4
    return( ++p % 4 );
#else
    return( ++p % 2 );
#endif
}

