#include "mbed.h"
#include "TextLCD.h"
#include "EthernetInterface.h"
#include "HTTPServer.h"

//EthernetNetIf eth;
HTTPServer svr;
DigitalOut myled(LED1);
TextLCD lcd(p24,p26,p27,p28,p29,p30); //rs,e,d4~d7
SPI spi(p5, p6, p7); // mosi, miso, sclk
DigitalOut cs(p8);

Serial pc(USBTX, USBRX); // tx, rx

int main() {
    pc.printf("Startup...\n");
    lcd.printf("Startup");
    
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());
    
    TCPSocketConnection sock;
    sock.connect("mbed.org", 80);
    
    char http_cmd[] = "GET /media/uploads/mbed_official/hello.txt HTTP/1.0\n\n";
    sock.send_all(http_cmd, sizeof(http_cmd)-1);
    
    char buffer[300];
    int ret;
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        printf("Received %d chars from server:\n%s\n", ret, buffer);
    }
    
    
      
    sock.close();
    
    eth.disconnect();
    
    pc.printf("Listening...\n");
    
    lcd.locate(0,1);
        // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    spi.format(16,3);
    spi.frequency(1000000);
 
    // Select the device by seting chip select low
    cs = 0;
 
    // Send 0x8f, the command to read the WHOAMI register
    spi.write(0x0000);
 
    // Send a dummy byte to receive the contents of the WHOAMI register
    int whoami = spi.write(0x0000);
    pc.printf("WHOAMI register = 0x%X\n", whoami);
    lcd.printf("0x%X\n",whoami);
    // Deselect the device
    cs = 1;
    while(1)
    {
 
    // Select the device by seting chip select low
    cs = 0;
 
    // Send 0x8f, the command to read the WHOAMI register
    //spi.write(0x0000);
 
    // Send a dummy byte to receive the contents of the WHOAMI register
    int outtemp = spi.write(0x0000);
    int intemp = spi.write(0x0000);
    pc.printf("outtemp  = 0x%X\n", outtemp);
    lcd.locate(0,0);
    lcd.printf("Out:0x%X\n",outtemp);
    pc.printf("intemp = 0x%X\n", intemp);
    lcd.locate(0,1);
    lcd.printf("In :0x%X",intemp);
    // Deselect the device
    cs = 1;
    float disp;
    if((outtemp& 0x8000) == 0){ // 0℃以上
      disp = (outtemp >> 4) * 0.0625;
    } else {                          // 0℃未満
      disp = (((0xffff - outtemp) >> 4) + 1)  * -0.0625;
    }
    pc.printf("Out:%4.2f[deg]\n",disp);
    
    if((intemp& 0x8000) == 0){ // 0℃以上
      disp = (intemp>> 4) * 0.0625;
    } else {                          // 0℃未満
      disp = (((0xffff - intemp) >> 4) + 1)  * -0.0625;
    }
    pc.printf("In:%4.2f[deg]\n",disp);
    wait(10);
    }
}
