#include "mbed.h"

//////////////////////////////////////////////////////////
////////    For TextLCD on StarBoard Orage        ////////
//////////////////////////////////////////////////////////
#include "TextLCD.h"
#ifdef  USE_TextLCD_20x4
//TextLCD     lcd( p24, p26, p27, p28, p29, p30, TextLCD::LCD20x4 ); // rs, e, d0-d3
#else
TextLCD     lcd( p24, p26, p27, p28, p29, p30 ); // rs, e, d0-d3
#endif

#include "SG12864A.h"
#include "imagedata.h"
SG12864A bwlcd;

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

int main() {
    char status;
    char s[8];
    myled1 = 0;
    myled2 = 0;
    myled3 = 0;
    myled4 = 0;
    lcd.cls();
    lcd.printf("SG12864A test");
    bwlcd.lcd_Init();
    wait(1);
    bwlcd.lcd_Clear(0); 
    wait(1);
    while(1) {
        int index;
        wait(1);
        bwlcd.lcd_Clear(0x00);
        myled1 = 1;
        wait(1);
        bwlcd.lcd_Clear(0xFF);
        myled1 = 0;
        myled2 = 1;
        wait(1);
        bwlcd.lcd_Clear(0x00);
        for(int i=0;i<=64;i++)
        {
            bwlcd.lcd_Pixel(i,i,1);
            bwlcd.lcd_Pixel(64+i,i,1);
        }
        myled1 = 1;
        wait(3);
        bwlcd.lcd_Clear(0xFF);
        for(int i=0;i<64;i++)
        {
            bwlcd.lcd_Pixel(64+i,i,0);
        }
        myled1 = 0;
        myled2 = 0;
        myled3 = 1;
        wait(3);
        bwlcd.lcd_Clear(0);
        for(int j=0;j<8;j++)
        {
            for(int i=0;i<16;i++)
            {
                index = j*16+i+0x20;
                bwlcd.lcd_Char(j,i,index);
            }
        }
        myled1 = 1; //0101
        wait(3);
        bwlcd.lcd_Clear(0);
        for(int j=0;j<8;j++)
        {
            for(int i=0;i<18;i++)
            {
                index = j*18+i+0x50;
                bwlcd.lcd_Char1(j,i,index);
            }
        }
        myled1=0;
        myled2=1; //0101 -> 0110
        wait(3);
        bwlcd.lcd_Image(Header2);
        myled1=1; //0110 -> 0111
        wait(3);
        bwlcd.lcd_Scroll(50);
        bwlcd.lcd_Image(Header3);
        myled4=1;
        myled3=0;
        myled2=0;
        myled1=0;
        wait(3);
        bwlcd.lcd_Scroll(100);
        wait(1);
        bwlcd.lcd_Clear(0);
        wait(1);
        bwlcd.lcd_Str(0,0,"Hello World!!");
        bwlcd.lcd_Str(2,0,"Graphic LCD test");
        myled1=1; //1000 -> 1001
        wait(1);
        bwlcd.lcd_Clear(0);
        for(int j=0; j<32; j+=2){				// Box 
					bwlcd.lcd_Line(j,j, 127-j, j);		// display small box
					bwlcd.lcd_Line(j,j, j, 63 -j);
					bwlcd.lcd_Line(127-j,63-j, 127-j,j);
					bwlcd.lcd_Line(128-j,63-j, j,63-j);
            wait_ms(500);
        }
        
    }
}
