//
// SG12864A Test Program
//
//

#ifndef SG12864A_H
#define SG12864A_H

#include "mbed.h"

#define DI p23
#define RW p22
#define E  p21
#define DB0 p20
#define DB1 p19
#define DB2 p14
#define DB3 p13
#define DB4 p12
#define DB5 p11
#define DB6 p10
#define DB7 p9
#define CS1 p17
#define CS2 p16
#define RST p15

#define ReflashRate 0.02


class SG12864A {
public:

    SG12864A();
    void lcd_Write(char cs, char code, char DIflag);
    char lcd_Read(char cs);
    char lcd_StatusRead(char cs);
    void lcd_Init(void);
    void lcd_Clear(char data);
    void lcd_Pixel(int Xpos, int Ypos, char On);     
    void lcd_Char(char line, char colum, int letter);
    void lcd_Char1(char line, char colum, int letter);
    void lcd_Str(char line, char colum, char *s);
    void lcd_Line(int x0, int y0, int x1, int y1);
    void lcd_Scroll(int delay);
    void lcd_Image(char *ptr);
    //void Delay200n(void);
    //void Delay1u(int time);
    //void Delay1m(int time);

private:
    DigitalOut  DI_OUT;
    DigitalOut  RW_OUT;
    DigitalOut  E_OUT;
    BusInOut      DB_OUT;
    //BusOut DB_OUT;
    DigitalOut  CS1_OUT;
    DigitalOut  CS2_OUT;
    DigitalOut  RST_OUT;
    Ticker      t;

    /** Displaying
     *  
     *  This function will be called by Ticker which set by this class' constructor. 
     *  It displays just one layer by single call. 
     */

   // void display( void );
    
};

#endif  // SG12864A





