//
//
//

#include "SG12864A.h"
#include "font.h"


 SG12864A::SG12864A() : DI_OUT(DI), RW_OUT(RW), E_OUT(E), DB_OUT(DB0,DB1,DB2,DB3,DB4,DB5,DB6,DB7),
                      CS1_OUT(CS1),CS2_OUT(CS2),RST_OUT(RST)
                      { DI_OUT = 0x01;RW_OUT = 0x01; E_OUT = 0x00;
                        DB_OUT = 0x00; 
                        DB_OUT.output();
                        CS1_OUT= 0x01; CS2_OUT=0x01; RST_OUT=0x01; 
                      //t.attach( this, &SG12864A::display, ReflashRate );
                      }
//Data output function
void SG12864A::lcd_Write(char cs, char code, char DIflag){
    int data;
    DB_OUT.output();
    RW_OUT = 0;
    if(cs==1)
        CS1_OUT=0;
    else
        CS2_OUT=0;
    data = (int)code;
    //DB_OUT = (DB_OUT & 0x00FF) | ((data<<8) & 0xFF00);
    DB_OUT = data & 0x00FF;
    if(DIflag == 0)
        DI_OUT = 1;
    else
        DI_OUT = 0;
    wait_us(1);
    E_OUT = 1;
    wait_us(1);
    E_OUT = 0;
    CS1_OUT = 1;
    CS2_OUT = 1;
    RW_OUT = 1;
    wait_us(5);
 }
 
 // Data Read Function
  char SG12864A::lcd_Read(char cs){
    int data;
    DB_OUT.input();
    RW_OUT = 1;
    if(cs==1)
        CS1_OUT = 0;
    else
        CS2_OUT = 0;
    DI_OUT = 1;
    wait_us(1);
    E_OUT = 1;
    wait_us(1);
    E_OUT = 0;
    wait_us(3);
    //data = (DB_OUT >>8 ) & 0x00FF;
    data = DB_OUT & 0x00FF;
    wait_us(1);
    CS1_OUT = 1;
    CS2_OUT = 1;
    DB_OUT.output();
    return((char)data);
 }
 
  // Data Read Function
  char SG12864A::lcd_StatusRead(char cs){
    int data;
    DB_OUT.input();
    RW_OUT = 1;
    if(cs==1)
        CS1_OUT = 0;
    else
        CS2_OUT = 0;
    DI_OUT = 0;
    wait_us(1);
    E_OUT = 1;
    wait_us(1);
    E_OUT = 0;
    wait_us(3);
    data = DB_OUT   & 0x00FF;
    wait_us(1);
    CS1_OUT = 1;
    CS2_OUT = 1;
    DB_OUT.output();
    return((char)data);
 }

 // Screen Clear Function
void SG12864A::lcd_Clear(char data){
    char page, colum;
    
    for(page=0; page<8;page++){         //repeat 8 page
        lcd_Write(1,0xB8+page,1);       //page set
        lcd_Write(1,0x40,1);            //column reset
        lcd_Write(2,0xB8+page,1);       //page set
        lcd_Write(2,0x40,1);            //column reset
        for(colum=0;colum<64;colum++){ //repeat 64column
            lcd_Write(1,data,0);        //fill data
            lcd_Write(2,data,0);        //fill data
        }
    }
    
    lcd_Write(1,0xC0,1);  //reset start line
    lcd_Write(2,0xC0,1);
}

// Initialize Function
void SG12864A::lcd_Init(void){
    RST_OUT = 0;
    wait_ms(1000);
    RST_OUT = 1;
    wait_ms(10);
    lcd_Write(1, 0x3F, 1);  // Display On
    lcd_Write(2, 0x3F, 1);  // Display On
    lcd_Clear(0);
}

// Draw Pixel Function
 void SG12864A::lcd_Pixel(int Xpos, int Ypos, char On){
    char cs, data, page, pos, count, i;

	/* if colum >127 then do nothing  */
	if(Xpos<128){
		if(Xpos>63){						// 64=<colum<=127?
			Xpos = Xpos-64;					// shift 64 dot
			cs = 1;
		}
		else
			cs = 2;
		page = (char)(7-Ypos/8);			// set page
		lcd_Write(cs, 0xB8+page, 1);			
		lcd_Write(cs, 0x40+Xpos, 1);		// set colum 
		data = lcd_Read(cs);				// get current data
		lcd_Write(cs, 0x40+Xpos, 1);		// set colum ???? 
		data = lcd_Read(cs);				// get current data	????	
		pos =1;								// set bit position
		count = (char)(7-Ypos%8);			// set bit
		for(i=0; i<count; i++)				// caluculate 2^n
			pos *= 2;
		lcd_Write(cs, 0x40+Xpos, 1);		// back address
		if(On==1)							// set or reset bit
			lcd_Write(cs, data | pos, 0);	// set 1
		else
			lcd_Write(cs, data & ~pos, 0);	// set 0
	}
}

//Draw Straight line Function      
#define	abs(a)	(((a)>0) ? (a) : -(a))
void SG12864A::lcd_Line(int x0, int y0, int x1, int y1)
{

	int steep, t;
	int	deltax, deltay, error;
	int x, y;
	int ystep;
	
	/// ̑傫ق߂
	steep = (abs(y1 - y0) > abs(x1 - x0));
	/// A̓ւ
	if(steep){
		t = x0; x0 = y0; y0 = t;
		t = x1; x1 = y1; y1 = t;
	}
	if(x0 > x1) {
		t = x0; x0 = x1; x1 = t;
		t = y0; y0 = y1; y1 = t;
	}
	deltax = x1 - x0;						// XvZ	
	deltay = abs(y1 - y0);
	error = 0;
	y = y0;
	/// XŃXebv̐؂ւ
	if(y0 < y1) ystep = 1; else ystep = -1;
	/// _ŕ`
	for(x=x0; x<x1; x++) {
		if(steep) lcd_Pixel(y,x,1); else lcd_Pixel(x,y,1);
		error += deltay;
		if((error << 1) >= deltax) {
			y += ystep;
			error -= deltax;
		}
	}
}


//Display Character Function
void SG12864A::lcd_Char(char line, char colum, int letter){
    char cs, i;
    int pos;
    
    if(colum < 16){
        if(colum >7){
            pos = (colum-8)*8;
            cs = 1;
        }
        else{
            pos = colum*8;
            cs = 2;
        }
        lcd_Write(cs, 0xB8+line,1);
        lcd_Write(cs, 0x40+pos,1);
        for(i=0; i<5; i++)
            lcd_Write(cs,Font[letter-0x20][i],0);
        lcd_Write(cs,0,0);
        lcd_Write(cs,0,0);
        lcd_Write(cs,0,0);
     }
}

// Display Character Function2
void SG12864A::lcd_Char1(char line, char colum, int letter){
    char cs, i;
    int pos;
    
    if(colum < 18){
        if(colum > 8){
            pos = (colum- 9) * 7;
              cs = 1;
        }
        else{
              pos = colum * 7;
              cs = 2;
        }
        lcd_Write(cs, 0xB8+line, 1);        // set page
        lcd_Write(cs, 0x40+pos, 1);            // set colum
        for(i=0; i<5; i++)
            lcd_Write(cs, Font[letter-0x20][i], 0);
        lcd_Write(cs, 0, 0);
        lcd_Write(cs, 0, 0);
    }
}

// Display Char Srings Function
void SG12864A::lcd_Str(char line, char colum, char *s)
{
    while(*s)
        SG12864A::lcd_Char1(line, colum++, *s++);
}

// Display Image Function
void SG12864A::lcd_Image(char *ptr)
{
    char cs, Xpos;
    int page, colum;

    for(page=0; page<8; page++){
        for(colum=0; colum<128; colum++){
            if(colum > 63){
                Xpos=colum-64;
                cs = 1;
            }
            else{
                Xpos = colum;
                cs = 2;
            }
            lcd_Write(cs, 0xB8+page, 1);
            lcd_Write(cs, 0x40+Xpos, 1);
            lcd_Write(cs, *ptr++, 0);
        }
    }
}

//Scroll Function
void SG12864A::lcd_Scroll(int delay){
    int i;
    
    for(i=0; i<64; i++){
        lcd_Write(1, 0xC0+i,1);
        lcd_Write(2, 0xC0+i,1);
        wait_ms(delay);
    }
}  
 