#include "REL225L01.h"


 REL225L01::REL225L01() : CS_OUT(CS), RS_OUT(RS), RD_OUT(RD), WR_OUT(WR),RST_OUT(RST),SCK_OUT(SCK),SDA_OUT(SDA)
                      { CS_OUT = 0x01;RS_OUT = 0x01; RD_OUT = 0x01;
                        WR_OUT = 0x01;RST_OUT = 0x01;
                        SCK_OUT= 0x01; SDA_OUT=0x01; 
                      //t.attach( this, &SG12864A::display, ReflashRate );
                      }

//Initialization LCD module
void  REL225L01::lcd_init(void){
    wait_ms(20);
    RD_OUT=1;
    CS_OUT=1;
    WR_OUT=1;
    RST_OUT=0;
    wait_ms(1);
    RST_OUT=1;
    wait_ms(25);
    
    lcd_cmd(0xB0);
    lcd_data(0xCA);
    lcd_data(0x90);
    lcd_data(0x37);
    lcd_data(0x01);
    lcd_data(0x48);
    lcd_data(0x01);
    lcd_data(0x40);
    lcd_data(0x04);
    lcd_data(0x00);
    lcd_data(0x00);

    lcd_cmd(0x26);
    lcd_data(0x01);
    
    lcd_cmd(0xB1);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x08);
    lcd_data(0x00);
    lcd_data(0x04);
    lcd_data(0x10);
    lcd_data(0x48);
    lcd_data(0x82);
    lcd_data(0x20);
    lcd_data(0x84);
    lcd_data(0x92);
    lcd_data(0x2A);
    lcd_data(0x52);
    lcd_data(0xAA);
    lcd_data(0x5A);
    lcd_data(0x55);
    lcd_data(0x2A);
    lcd_data(0x55);
    lcd_data(0xAE);
    lcd_data(0xFF);
    lcd_data(0xFE);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x04);

    lcd_cmd(0xB2);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x04);
    lcd_data(0x00);
    lcd_data(0x02);
    lcd_data(0x08);
    lcd_data(0x48);
    lcd_data(0x82);
    lcd_data(0x20);
    lcd_data(0x84);
    lcd_data(0x42);
    lcd_data(0x48);
    lcd_data(0x92);
    lcd_data(0x2A);
    lcd_data(0x52);
    lcd_data(0xAA);
    lcd_data(0x5A);
    lcd_data(0x55);
    lcd_data(0x2A);
    lcd_data(0x55);
    lcd_data(0xAE);
    lcd_data(0xFF);
    lcd_data(0xFE);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x04);

    lcd_cmd(MODE);            // Entry Mode
    lcd_data(0x29);
    //color mode
    lcd_cmd(COLMOD);
    lcd_data(0x05);            //65k color
    //Inteface mode
    lcd_cmd(IFMOD);
    lcd_data(0x03);            //16bit mode


    lcd_cmd(0xBA);
    lcd_data(0x55);
    lcd_data(0x55);    
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);    
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);    
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);    
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);    
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);    
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);    
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);    
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);    
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);    
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);    
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);    
    lcd_data(0x55);


    //
    lcd_cmd(SLPOUT);
    lcd_cmd(DISON);            //Display On
}
    
    
                      
//Command output function
void REL225L01::lcd_cmd(unsigned int comm){
    if(comm<=0xffff)
    {

       for(int i=0;i<16;i++)
       {
        SDA_OUT = ((comm >> i) & 0x1);
        SCK_OUT = 0;
        SCK_OUT = 1;
       }
        RS_OUT = 0;
        CS_OUT = 0;
        WR_OUT = 0;
        //wait_us(1);
        RS_OUT = 1; 
        WR_OUT = 1;
        CS_OUT = 1;
       // wait_us(1);
       
     }   
 }
 
 void REL225L01::lcd_data(unsigned int data){
    if(data<=0xffff)
    {
       for(int i=0;i<16;i++)
       {
        SDA_OUT = ((data >> i) & 0x1);
        SCK_OUT = 0;
        SCK_OUT = 1;
       }
        CS_OUT = 0;
        WR_OUT = 0;
        //wait_us(1);
        WR_OUT = 1;
        CS_OUT = 1;
       // wait_us(1);
     }   
 }
 
 /***************************
* &#65533;&#65533;&#655;&#65533;&#65533;&#65533;&#1424;&#65533;
* &#65533;&#65533;&#65533;&#65533;p&#65533;F&#65533;w&#65533;&#32928;&#65533;&#65533;
****************************/
void REL225L01::lcd_clear(unsigned short Color){
    int i, j;

    lcd_cmd(PASET);            // &#65533;y&#65533;[&#65533;W&#65533;J&#65533;n&#65533;I&#65533;&#65533;&#65533;A&#65533;h&#65533;&#65533;&#65533;X&#65533;Z&#65533;b&#65533;g
    lcd_data(0);
    lcd_data(0x0C);
    lcd_data((unsigned char)((ENDPAGE+0x0C)>>8));
    lcd_data((unsigned char)(ENDPAGE+0x0C));
    //lcd_data(ENDPAGE);
    
    lcd_cmd(CASET);            // &#65533;R&#65533;&#65533;&#65533;&#65533;&#65533;J&#65533;n&#65533;A&#65533;I&#65533;&#65533;&#65533;A&#65533;h&#65533;&#65533;&#65533;X&#65533;Z&#65533;b&#65533;g
    lcd_data(0);
    lcd_data(0x08);
    lcd_data((unsigned char)((ENDCOL+0x08)>>8)); 
    lcd_data((unsigned char)(ENDCOL+0x08));
    //lcd_data(ENDCOL);
    
    lcd_cmd(RAMWR);
    for(j=0; j<4; j++){
        for(i=0; i<(ENDCOL+1)*80; i++){
            //lcd_data((unsigned char)(Color>>8));
            //lcd_data((unsigned char)Color);
            lcd_data(Color);
        }
    }    
}

/***********************************
*  &#65533;P&#65533;s&#65533;N&#65533;Z&#65533;&#65533;&#65533;\&#65533;&#65533;&#65533;&#1424;&#65533;
*  &#65533;&#65533;W&#65533;&#65533;(0,0)-(161,131)  
***********************************/
void REL225L01::lcd_pixel(short Xpos, short Ypos, unsigned short Color){

    if((Xpos<=ENDCOL) && (Ypos<=ENDPAGE)){
        Xpos += 0x08;
        Ypos += 0x0C;
        lcd_cmd(PASET);                // &#65533;s&#65533;iRAW)&#65533;A&#65533;h&#65533;&#65533;&#65533;X&#65533;Z&#65533;b&#65533;g
        lcd_data(Ypos>>8);
        lcd_data(Ypos);
        lcd_data(Ypos>>8);
        lcd_data(Ypos);
        lcd_cmd(CASET);                // &#65533;&#65533;iCOLUM)&#65533;A&#65533;h&#65533;&#65533;&#65533;X&#65533;Z&#65533;b&#65533;g
        lcd_data((unsigned char)((Xpos)>>8));
        lcd_data((unsigned char)(Xpos));
        lcd_data((unsigned char)(Xpos>>8));
        lcd_data((unsigned char)(Xpos));
        lcd_cmd(RAMWR);                // 1&#65533;s&#65533;N&#65533;Z&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;
        //lcd_data(Color >> 8);            // 16&#65533;r&#65533;b&#65533;g&#65533;J&#65533;&#65533;&#65533;[
        lcd_data(Color);
    }
}
 
/*********************************************************
* &#65533;C&#65533;&#65533;&#65533;[&#65533;W&#65533;\&#65533;&#65533;&#65533;&#1424;&#65533;
*&#65533;@ &#65533;f&#65533;[&#65533;^&#65533;&#847;c&#65533;&#65533;&#65533;8&#65533;&#65533;&#65533;C&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;1&#65533;o&#65533;C&#65533;g&#65533;&#330;i&#65533;[&#65533;&#65533;&#65533;&#65533;&#258;&#65533;&#65533;&#65533;
*   128&#65533;~128/8=2k&#65533;o&#65533;C&#65533;g/&#65533;&#65533;&#65533;
*   &#65533;O&#65533;&#65533;&#65533;t&#65533;B&#65533;b&#65533;N&#65533;F(Color1)&#65533;&#404;w&#65533;i&#65533;F(Color2)&#65533;&#65533;&#65533;&#65533;&#65533;w&#65533;&#65533;
**********************************************************/
void REL225L01::lcd_image(char line, const unsigned char *ptr, unsigned short Color1, unsigned Color2)
{
    unsigned char Mask;
    short i, vline, colum;


    for(vline=line; vline<line+8; vline++){                // &#65533;S&#65533;&#770;&#65533;8&#65533;s&#65533;~8=64&#65533;&#65533;&#65533;C&#65533;&#65533;
        for(colum=0; colum<128; colum++){        // &#65533;&#65533;&#65533;&#65533;128&#65533;h&#65533;b&#65533;g&#65533;&#386;&#65533;&#65533;&#65533;
            Mask = 0x01;                        // &#65533;&#65533;&#65533;&#643;r&#65533;b&#65533;g&#65533;&#65533;&#65533;&#13412;
            for(i=0; i<8; i++){                // 1&#65533;o&#65533;C&#65533;g&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;
                if(*ptr & Mask)                // &#65533;r&#65533;b&#65533;g&#65533;`&#65533;F&#65533;b&#65533;N
                    lcd_pixel(colum+2, vline*8+i+1, Color1);
                else
                    lcd_pixel(colum+2,vline*8+i+1,  Color2);                    
                Mask = Mask << 1;                // &#65533;r&#65533;b&#65533;g&#65533;&#658;u&#65533;V&#65533;t&#65533;g
            } 
            ptr++;                            // &#65533;&#65533;&#65533;&#771;f&#65533;[&#65533;^
        }
    }
}
