//

#include "mbed.h"

#include "REL225L01.h"
REL225L01 tft;
#include "imagedata.h"

////////////////////////////////////////
////////    For SD_card         ////////
////////////////////////////////////////
#include "SDHCFileSystem.h"
SDFileSystem  sd(p5, p6, p7, p8,  "sd");  //  mosi, miso, sclk, cs, name  (HW modification candidate)

////////////////////////////////////////
////////    For TextLCD         ////////
////////////////////////////////////////
#include "TextLCD.h"
#ifdef  USE_TextLCD_20x4
//TextLCD     lcd( p24, p26, p27, p28, p29, p30, TextLCD::LCD20x4 ); // rs, e, d0-d3
#else
TextLCD     lcd( p24, p26, p27, p28, p29, p30 ); // rs, e, d0-d3
#endif

DigitalOut myled(LED1);

void test_file_write( char *title, char *path );
int  position( void );

LocalFileSystem local("local"); 

int main() {
    tft.lcd_init();
    printf("\r\n--------------- Starting -----------------\r\n");
    lcd.printf("----Starting----");
    lcd.locate(0,1);
    wait(3);
    test_file_write( "SD card", "/sd/star_bd.txt" );
    wait(2);
    while(1){
       tft.lcd_clear(BLACK);
       //wait(1);
       tft.lcd_clear(WHITE);
      // wait(1);
       tft.lcd_clear(RED);
       //wait(1);
       tft.lcd_clear(GREEN);
      // wait(1);
       tft.lcd_clear(BLUE);
       //tft.lcd_clear(BLACK);
       //tft.lcd_image(0, Header1, MAGENTA, BLACK);
       //tft.lcd_image(8, Header2, CYAN, BLACK);
        FILE *fp = fopen("/sd/test1.bmp", "rb"); 
       if ( fp == NULL ) {
        lcd.printf( "error" );
        error( "Could not open file for write\n" );
       }
       int dat;
       int Bdat,Gdat,Rdat;
       int RGBdat;
       for(int i=0;i<54;i++)
       {
        dat=fgetc(fp); //Header
       }
       tft.lcd_cmd(RAMWR);
       for(int i=0;i<=320;i++)
       {
        for(int j=0;j<=240;j++)
        {
            Bdat=fgetc(fp);
            Gdat=fgetc(fp);
            Rdat=fgetc(fp);
            RGBdat=((Rdat&0xF8)<<8)+((Gdat&0xFC)<<3)+((Bdat&0xF8)>>3);
            tft.lcd_data(RGBdat);
        }
       }
       fclose(fp);
       wait(3);
       
       FILE *fp2 = fopen("/sd/test2.bmp", "rb"); 
       if ( fp2 == NULL ) {
        lcd.printf( "error" );
        error( "Could not open file for write\n" );
       }
       for(int i=0;i<54;i++)
       {
        dat=fgetc(fp2); //Header
       }
       tft.lcd_cmd(RAMWR);
       for(int i=0;i<=320;i++)
       {
        for(int j=0;j<=240;j++)
        {
            Bdat=fgetc(fp2);
            Gdat=fgetc(fp2);
            Rdat=fgetc(fp2);
            RGBdat=((Rdat&0xF8)<<8)+((Gdat&0xFC)<<3)+((Bdat&0xF8)>>3);
            tft.lcd_data(RGBdat);
        }
       }
       fclose(fp2);
       wait(3);
       
            
       wait(1);
    }
    

}


void test_file_write( char *title, char *path ) {
    //  SD card test
    lcd.locate( 0, position() );
    lcd.printf( "%s: ", title );

    FILE *fp = fopen( path, "w" );
    if ( fp == NULL ) {
        lcd.printf( "error" );
        error( "Could not open file for write\n" );
    }
    fprintf( fp, "The mbed writing a file through the star board orange (%s)!", title );
    fclose( fp );

    lcd.printf( "OK." );
}

int position( void ) {
    static int  p   = 0;

#ifdef  USE_TextLCD_20x4
    return( ++p % 4 );
#else
    return( ++p % 2 );
#endif
}
