//
// SG12864A Test Program
//
//

#ifndef SG12864A_H
#define SG12864A_H

#include "mbed.h"

#define CS p19
#define RS p18
#define RD p17
#define WR p16
#define RST p15
#define SCK p13
#define SDA p12

/*****************************************
* Epson S1D15G10 Command Set
*****************************************/
#define MODE        0x36
#define CASET        0x2A
#define PASET        0x2B
#define COLMOD    0x3A
#define IFMOD        0xC2
#define RAMWR        0x2C
#define SLPOUT    0x11
#define DISON        0x29

#define ENDCOL      319    // X
#define ENDPAGE     239    // Y
#define XChar          (short)((ENDCOL+1) / 12)
#define YLine          (short)((ENDPAGE+1) / 14)

/*******************************************
*  16bit Color Difinition
*******************************************/
#define WHITE        0xFFFF
#define BLACK        0x0000
#define RED        0xF800
#define GREEN        0x07E0
#define BLUE        0x001F
#define CYAN        0x07FF
#define MAGENTA    0xF81F
#define YELLOW    0xFFE0
#define BROWN        0xA18A
#define ORANGE    0xFBC0
#define PINK        0xF998

class REL225L01 {
public:

    REL225L01();
    void lcd_cmd(unsigned int comm);
    void lcd_data(unsigned int data);
    void lcd_init(void);
    void lcd_clear(unsigned short Color);
    void lcd_pixel(short Xpos, short Ypos, unsigned short Color);
    void lcd_image(char line, const unsigned char *ptr, unsigned short Color1, unsigned Color2);
    //void lcd_init(void);
    //void lcd_Image(char *ptr);


private:
    DigitalOut  CS_OUT;
    DigitalOut  RS_OUT;
    DigitalOut  RD_OUT;
    DigitalOut  WR_OUT;
    DigitalOut  RST_OUT;
    DigitalOut  SCK_OUT;
    DigitalOut  SDA_OUT;
    //Ticker      t;

};

#endif  
 
