#include "mbed.h"
#include "OV7670.h"
#include "REL225L01.h"
REL225L01 tft;

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
InterruptIn VSYNC_IN(p5);
DigitalOut CMOS_CS(p20);
DigitalOut EN_EXCLK(p21);
DigitalOut EN_595(p23);
I2C i2c(p9,p10); //sda, scl


void flip1()
{
    EN_595 = 0;
    tft.lcd_cw_start();
    EN_595 = 1;   
    EN_EXCLK = 1;
    CMOS_CS = 0;
}

void flip2()
{
    EN_595 = 0;
    tft.lcd_cw_end();
    EN_595 = 1;
    EN_EXCLK = 0;
    CMOS_CS = 1;
}
    

int main() {
   char cmd[2];
   CMOS_CS = 1;   
   EN_EXCLK=0;
   EN_595=0;
   myled1=1;
   i2c.start();
   //
   //cmd[0] = REG_CLKRC; //
   //cmd[1] = 0x01; //Set Camera Active
   //i2c.write(OV7670_I2C_ADDR,cmd,2); // send string
   //wait(0.07); //could also pull,65ms is typical
   
   regval_list *vals=ov7670_default_regs;
   //while(vals->reg_num!=0xff||vals->value!=0xff)
   while(vals->reg_num!=0xff||vals->value!=0xff)
   {
    cmd[0] = vals->reg_num;
    cmd[1] = vals->value;
    i2c.write(OV7670_I2C_ADDR,cmd,2);
    wait(0.01);
   vals++;
   }
   
   vals=ov7670_fmt_rgb565;
   //while(vals->reg_num!=0xff||vals->value!=0xff)
   while(vals->reg_num!=0xff||vals->value!=0xff)
   {
    cmd[0] = vals->reg_num;
    cmd[1] = vals->value;
    i2c.write(OV7670_I2C_ADDR,cmd,2);
    wait(0.01);
   vals++;
   }
   
   wait(2);
 
   unsigned char v;
   // Horizontal setting: 11bits, top 8 live in hstart and hstop. Bottom 3 of
   // hstart are in href[2:0], bottom 3 of hstop in href[5:3]. There is
   //a mystery "edge offset" value in the top two bit fo href.
   
   cmd[0] = REG_HSTART;
   cmd[1] = (hstart>>3)&0xff;
   i2c.write(OV7670_I2C_ADDR,cmd,2);
   wait(0.01);
   cmd[0] = REG_HSTOP;
   cmd[1] = (hstop >> 3) & 0xff;
   i2c.write(OV7670_I2C_ADDR,cmd,2);
   //v = (0xb6 & 0xc0) | ((hstop & 0x07)<<3)| (hstart & 0x07);
   v = (0x80 & 0xc0) | ((hstop & 0x07)<<3)| (hstart & 0x07);
   wait(0.01);
   cmd[0] = REG_HREF;
   cmd[1] = v;
   i2c.write(OV7670_I2C_ADDR,cmd,2);
   
   /*
    * Vertical : simillar arrangement, but only 10 bits
    */
   cmd[0] = REG_VSTART;
   cmd[1] = (vstart>>2)&0xff;
   i2c.write(OV7670_I2C_ADDR,cmd,2);
   wait(0.01);
   cmd[0] = REG_VSTOP;
   cmd[1] = (vstop >>2) & 0xff;
   i2c.write(OV7670_I2C_ADDR,cmd,2);
   v = (0x0a & 0xf0) | ((vstop & 0x03) <<2) | (vstart & 0x03);
   cmd[0] = REG_VREF;
   cmd[1] = v;
   wait(0.01);
   i2c.write(OV7670_I2C_ADDR,cmd,2);
   cmd[0] =  REG_COM7;
   cmd[1] = COM7_FMT_QVGA | COM7_RGB;
   wait(0.01);
   i2c.write(OV7670_I2C_ADDR,cmd,2);
   
   i2c.stop();
   
   myled1=0;
   myled2=1;
   // TFT-LCD setting
   tft.lcd_init();
   tft.lcd_clear(BLUE);
   //wait(1);
   //tft.lcd_clear(RED);
   //wait(1);
   tft.lcd_cw_start();
   //Changing Internal/External WR, Data by VSYNC signal of CMOS Camera module 
   //LCD module write period : 2sec
   EN_595 = 1;
   
   VSYNC_IN.fall(&flip1); 
   VSYNC_IN.rise(&flip2);
   
   //wait(0.28);
   
   //Stop Re-Display 
   //tft.lcd_cw_end();
   //VSYNC_IN.fall(&flip2);
   
   myled2=0;
    while(1) {
        myled3 = 1;
        wait(0.2);
        myled3 = 0;
        wait(0.2);
    }
}
