//
// SG12864A Test Program
//
//

#ifndef REL225L01_H
#define REL225L01_H

#include "mbed.h"

#define CS p16
#define RS p17
#define RD p18
#define _WR p14
#define RST p15
#define MOSI p11
#define MISO p12
#define SCK p13
#define RCK p22

/*****************************************
* Epson S1D15G10 Command Set
*****************************************/
#define MODE        0x36
#define CASET        0x2A
#define PASET        0x2B
#define COLMOD    0x3A
#define IFMOD        0xC2
#define RAMWR        0x2C
#define SLPOUT    0x11
#define DISON        0x29

#define ENDCOL      319    // X
#define ENDPAGE     239    // Y
#define XChar          (short)((ENDCOL+1) / 12)
#define YLine          (short)((ENDPAGE+1) / 14)

/*******************************************
*  16bit Color Difinition
*******************************************/
#define WHITE        0xFFFF
#define BLACK        0x0000
#define RED        0xF800
#define GREEN        0x07E0
#define BLUE        0x001F
#define CYAN        0x07FF
#define MAGENTA    0xF81F
#define YELLOW    0xFFE0
#define BROWN        0xA18A
#define ORANGE    0xFBC0
#define PINK        0xF998

class REL225L01 {
public:

    REL225L01();
    void lcd_cmd(unsigned int comm);
    void lcd_data(unsigned int data);
    void lcd_init(void);
    void lcd_clear(unsigned short Color);
    void lcd_cw_start(void);
    void lcd_cw_end(void);
    
private:
    DigitalOut  CS_OUT;
    DigitalOut  RS_OUT;
    DigitalOut  RD_OUT;
    DigitalOut  WR_OUT;
    DigitalOut  RST_OUT;
    DigitalOut  RCK_OUT;
    SPI spi;
    //DigitalOut  SCK_OUT;
    //DigitalOut  SDA_OUT;
    //Ticker      t;

};

#endif  