#include "REL225L01.h"
//This program is for using 74HC595 and SPI I/F
//


 REL225L01::REL225L01() : CS_OUT(CS), RS_OUT(RS), RD_OUT(RD), WR_OUT(_WR),RST_OUT(RST),RCK_OUT(RCK),spi(MOSI,MISO,SCK)//SCK_OUT(SCK),SDA_OUT(SDA)
                      { CS_OUT = 0x01;RS_OUT = 0x01; RD_OUT = 0x01;
                        WR_OUT = 0x01;RST_OUT = 0x01;RCK_OUT = 0x00;
                       //SCK_OUT= 0x01; SDA_OUT=0x01; 
                      //t.attach( this, &SG12864A::display, ReflashRate );
                      }

//Initialization LCD module
void  REL225L01::lcd_init(void){
    spi.format(8,3);
    spi.frequency(20000000);

    wait_ms(20);
    RCK_OUT=0;
    RD_OUT=1;
    CS_OUT=1;
    WR_OUT = 0;
    //WR_OUT=1;
    RST_OUT=0;
    wait_ms(1);
    RST_OUT=1;
    wait_ms(25);
    
    lcd_cmd(0xB0);
    lcd_data(0xCA);
    lcd_data(0x90);
    lcd_data(0x37);
    lcd_data(0x01);
    lcd_data(0x48);
    lcd_data(0x01);
    lcd_data(0x40);
    lcd_data(0x04);
    lcd_data(0x00);
    lcd_data(0x00);

    lcd_cmd(0x26);
    lcd_data(0x01);
    
    lcd_cmd(0xB1);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x08);
    lcd_data(0x00);
    lcd_data(0x04);
    lcd_data(0x10);
    lcd_data(0x48);
    lcd_data(0x82);
    lcd_data(0x20);
    lcd_data(0x84);
    lcd_data(0x92);
    lcd_data(0x2A);
    lcd_data(0x52);
    lcd_data(0xAA);
    lcd_data(0x5A);
    lcd_data(0x55);
    lcd_data(0x2A);
    lcd_data(0x55);
    lcd_data(0xAE);
    lcd_data(0xFF);
    lcd_data(0xFE);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x04);

    lcd_cmd(0xB2);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x04);
    lcd_data(0x00);
    lcd_data(0x02);
    lcd_data(0x08);
    lcd_data(0x48);
    lcd_data(0x82);
    lcd_data(0x20);
    lcd_data(0x84);
    lcd_data(0x42);
    lcd_data(0x48);
    lcd_data(0x92);
    lcd_data(0x2A);
    lcd_data(0x52);
    lcd_data(0xAA);
    lcd_data(0x5A);
    lcd_data(0x55);
    lcd_data(0x2A);
    lcd_data(0x55);
    lcd_data(0xAE);
    lcd_data(0xFF);
    lcd_data(0xFE);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x00);
    lcd_data(0x04);

    lcd_cmd(MODE);            // Entry Mode
    lcd_data(0x29);           // 0b00101001 : 0 I/D1 AM 0 BGR 0 0 I/D0
                              // ID[1:0] = 00: H:increment, V:increment
                              //           01: H:increment, V:decrement
                              //           10: H:Decrement, V:increment
                              //           11: H:Decrement, V:decrement
                              // AM = 0 : Horizontal , AM=1: Vertical 
                              //BGR : Reverse Red and Blue 
    //color mode
    lcd_cmd(COLMOD);
    lcd_data(0x05);            //65k color
    //Inteface mode
    lcd_cmd(IFMOD);
    lcd_data(0x00);            //Data[2:0] = I/F mode
                               //          = 000 : 8bit I/F
                               //          = 011 : 16bit I/F
                               //          = 100 : 18bit I/F


    lcd_cmd(0xBA);
    lcd_data(0x55);
    lcd_data(0x55);    
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);    
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);    
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);    
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);    
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);    
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);    
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);    
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);    
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);    
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);    
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);
    lcd_data(0x55);    
    lcd_data(0x55);


    //
    lcd_cmd(SLPOUT);
    lcd_cmd(DISON);            //Display On
}

                      
//Command output function
void REL225L01::lcd_cmd(unsigned int comm){
    if(comm<=0xffff)
    {

       //for(int i=0;i<16;i++)
       //{
       // SDA_OUT = ((comm >> i) & 0x1);
       // SCK_OUT = 0;
       // SCK_OUT = 1;
       //}
       //rotate
       
       unsigned int B=0;
       /*
       B=((comm>>15)&0x0001)+((comm>>13)&0x0002)+((comm>>11)&0x0004)
        +((comm>>9)&0x0008)+((comm>>7)&0x0010)+((comm>>5)&0x0020)
        +((comm>>3)&0x0040)+((comm>>1)&0x0080)
        +((comm<<1)&0x0100)+((comm<<3)&0x0200)+((comm<<5)&0x0400)+((comm<<7)&0x0800)
        +((comm<<9)&0x1000)+((comm<<11)&0x2000)+((comm<<13)&0x4000)+((comm<<15)&0x8000);
       */
       B = comm & 0xff;
       spi.write(B); 
       //74HC595 Output control
       RCK_OUT = 1;
       RCK_OUT = 0;
        //spi.write(comm);
        RS_OUT = 0;
        CS_OUT = 0;
        WR_OUT = 1;
        //WR_OUT = 0;
        //wait_us(1);
        RS_OUT = 1; 
        WR_OUT = 0;
        //WR_OUT = 1;
        CS_OUT = 1;
       // wait_us(1);
       
     }   
 }
 
 void REL225L01::lcd_data(unsigned int data){
    if(data<=0xffff)
    {
       //for(int i=0;i<16;i++)
       //{
       // SDA_OUT = ((data >> i) & 0x1);
       // SCK_OUT = 0;
       // SCK_OUT = 1;
       //}
       
       unsigned int B=0;
       /*
       B=((data>>15)&0x0001)+((data>>13)&0x0002)+((data>>11)&0x0004)
        +((data>>9)&0x0008)+((data>>7)&0x0010)+((data>>5)&0x0020)
        +((data>>3)&0x0040)+((data>>1)&0x0080)
        +((data<<1)&0x0100)+((data<<3)&0x0200)+((data<<5)&0x0400)+((data<<7)&0x0800)
        +((data<<9)&0x1000)+((data<<11)&0x2000)+((data<<13)&0x4000)+((data<<15)&0x8000);
       */
       B = data & 0xff;
       spi.write(B);
       //74HC595 Output control 
       RCK_OUT = 1;
       RCK_OUT = 0;
       //spi.write(data);
        CS_OUT = 0;
        WR_OUT = 1;
        //WR_OUT = 0;
        //wait_us(1);
        WR_OUT = 0;
        //WR_OUT = 1;
        CS_OUT = 1;
       // wait_us(1);
     }   
 }
 

void REL225L01::lcd_clear(unsigned short Color){
    int i, j;

    lcd_cmd(PASET);           
    lcd_data(0);
    lcd_data(0x0C);
    lcd_data((unsigned char)((ENDPAGE+0x0C)>>8));
    lcd_data((unsigned char)(ENDPAGE+0x0C));
    //lcd_data(ENDPAGE);
    
    lcd_cmd(CASET);           
    lcd_data(0);
    lcd_data(0x08);
    lcd_data((unsigned char)((ENDCOL+0x08)>>8)); 
    lcd_data((unsigned char)(ENDCOL+0x08));
    //lcd_data(ENDCOL);
    
    lcd_cmd(RAMWR);
    for(j=0; j<4; j++){
        for(i=0; i<(ENDCOL+1)*80; i++){
            lcd_data((unsigned char)(Color>>8));
            lcd_data((unsigned char)Color);
            //lcd_data(Color);
        }
    }    
}

void REL225L01::lcd_cw_start(void)
{
 
   lcd_cmd(RAMWR);
   CS_OUT = 0;
   WR_OUT = 1;
}

void REL225L01::lcd_cw_end(void)
{
    CS_OUT = 1;
    WR_OUT = 0;
}


