#include "mbed.h"

DigitalOut myled(LED1);
DigitalOut myled2(LED2);
SPI spi(p5, p6, p7); // mosi, miso, sclk
DigitalOut LEDRSTN(p30); //for Reset(Slot1)
DigitalOut LEDLATCH(p29); //for LATCH(Slot1)
DigitalOut LED2RSTN(p21); //for Reset(Slot2)
DigitalOut LED2LATCH(p22); //for LATCH(Slot2)
DigitalOut LED3RSTN(p23); //for Reset(Slot3)
DigitalOut LED3LATCH(p24); //for LATCH(Slot3)
Ticker flipper;

//====================
// Global : LED Array
//====================
// for each element
//   bit1 : Green
//   bit0 : Red
int gLED_ARRAY[8][8];
int gLED2_ARRAY[8][8];
int gLED3_ARRAY[8][8];

void Init_LED_Array(void)
{
    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    spi.format(8,3);
    spi.frequency(100000);
    int x=0;
    int y=0;
    
    LEDRSTN = 0;
    LED2RSTN = 0;
    LED3RSTN = 0;
    wait(0.1);
    LEDRSTN = 1;
    LED2RSTN = 1;
    LED3RSTN = 1;
    // Clear LED Array Buffer
    for (y = 0; y < 8; y++)
    {
        for (x = 0; x < 8; x++)
        {
            gLED_ARRAY[y][x] = 0;
            gLED2_ARRAY[y][x] = 0;
            gLED3_ARRAY[y][x] = 0;
        }
    }
}

//==================
// Scan LED Array
//==================
// Caller of TIMER16_0_IRQHandler()
void Scan_LED_Array(void)
{
    static int x = 0,x2=0,x3=0;
    int y;
    int row,row2,row3;
    int col_LED_ARRAY_RED,col_LED_ARRAY_RED2,col_LED_ARRAY_RED3;
    int col_LED_ARRAY_GRN,col_LED_ARRAY_GRN2,col_LED_ARRAY_GRN3;

    row = 1 << x;
    row2 = 1 <<x2;
    row3 = 1 <<x3;
    //
    col_LED_ARRAY_RED = 0;
    col_LED_ARRAY_RED2 = 0;
    col_LED_ARRAY_RED3 = 0;
    for (y = 0; y < 8; y++)
    {
        col_LED_ARRAY_RED = col_LED_ARRAY_RED | ((gLED_ARRAY[y][x] & 0x01) << (7 - y));
        col_LED_ARRAY_RED2 = col_LED_ARRAY_RED2 | ((gLED2_ARRAY[y][x2] & 0x01) << (7 - y));
        col_LED_ARRAY_RED3 = col_LED_ARRAY_RED3 | ((gLED3_ARRAY[y][x3] & 0x01) << (7 - y));
    }
    //
    col_LED_ARRAY_GRN = 0;
    col_LED_ARRAY_GRN2 = 0;
    col_LED_ARRAY_GRN3 = 0;
    for (y = 0; y < 8; y++)
    {
        col_LED_ARRAY_GRN = col_LED_ARRAY_GRN | (((gLED_ARRAY[y][x] & 0x02) >> 1) << (7 - y));
        col_LED_ARRAY_GRN2 = col_LED_ARRAY_GRN2 | (((gLED2_ARRAY[y][x] & 0x02) >> 1) << (7 - y));
        col_LED_ARRAY_GRN3 = col_LED_ARRAY_GRN3 | (((gLED3_ARRAY[y][x] & 0x02) >> 1) << (7 - y));
    }
    //
    spi.write(row);
    spi.write(col_LED_ARRAY_RED);
    spi.write(col_LED_ARRAY_GRN);
    
    //
    LEDLATCH=1; // high
    LEDLATCH=0; // low (latch)
    //
    spi.write(row2);
    spi.write(col_LED_ARRAY_RED2);
    spi.write(col_LED_ARRAY_GRN2);
    //
    LED2LATCH=1;
    LED2LATCH=0;
    //
    spi.write(row3);
    spi.write(col_LED_ARRAY_RED3);
    spi.write(col_LED_ARRAY_GRN3);
    //
    LED3LATCH=1;
    LED3LATCH=0;
    
    x = (x + 1) & 0x07;
    x2 = (x2+1) & 0x07;
    x3 = (x3+1) & 0x07;
}

//===================
// Set LED Array
//===================
void Set_LED_Array(int x, int y, int color)
{
    gLED_ARRAY[y][x] = color;
}

void Set_LED2_Array(int x, int y, int color)
{
    gLED2_ARRAY[y][x] = color;
}

void Set_LED3_Array(int x, int y, int color)
{
    gLED3_ARRAY[y][x] = color;
}


//Interrupt Handler
void scanLED(void)
{
    Scan_LED_Array();
}
     

int main() {
    Init_LED_Array();
    flipper.attach(&scanLED,0.001);
    while(1) {
        myled = 1;
        myled2=0;
        Set_LED_Array(5,0,0x01);
        Set_LED_Array(2,1,0x01);
        Set_LED_Array(3,1,0x01);
        Set_LED_Array(4,1,0x01);
        Set_LED_Array(5,1,0x01);
        Set_LED_Array(6,1,0x01);
        Set_LED_Array(7,1,0x01);
        Set_LED_Array(5,2,0x01);
        Set_LED_Array(3,3,0x01);
        Set_LED_Array(4,3,0x01);
        Set_LED_Array(5,3,0x01);
        Set_LED_Array(6,3,0x01);
        Set_LED_Array(7,3,0x01);
        Set_LED_Array(5,4,0x01);
        Set_LED_Array(2,5,0x01);
        Set_LED_Array(3,5,0x01);
        Set_LED_Array(4,5,0x01);
        Set_LED_Array(5,5,0x01);
        Set_LED_Array(1,6,0x01);
        Set_LED_Array(5,6,0x01);
        Set_LED_Array(6,6,0x01);
        Set_LED_Array(2,7,0x01);
        Set_LED_Array(3,7,0x01);
        Set_LED_Array(4,7,0x01);
        Set_LED_Array(7,7,0x01);
        Set_LED2_Array(1,3,0x01);
        Set_LED2_Array(2,3,0x01);
        Set_LED2_Array(3,3,0x01);
        Set_LED2_Array(4,3,0x01);
        Set_LED2_Array(5,3,0x01);
        Set_LED2_Array(6,4,0x01);
        Set_LED2_Array(6,5,0x01);
        Set_LED2_Array(6,6,0x01);
        Set_LED2_Array(3,7,0x01);
        Set_LED2_Array(4,7,0x01);
        Set_LED2_Array(5,7,0x01);
        Set_LED3_Array(5,0,0x01);
        Set_LED3_Array(4,1,0x01);
        Set_LED3_Array(3,2,0x01);
        Set_LED3_Array(2,3,0x01);
        Set_LED3_Array(2,4,0x01);
        Set_LED3_Array(3,5,0x01);
        Set_LED3_Array(4,6,0x01);
        Set_LED3_Array(5,7,0x01);
        wait(1.5);
        myled = 0;
        myled2=1;
        Set_LED_Array(5,0,0x02);
        Set_LED_Array(2,1,0x02);
        Set_LED_Array(3,1,0x02);
        Set_LED_Array(4,1,0x02);
        Set_LED_Array(5,1,0x02);
        Set_LED_Array(6,1,0x02);
        Set_LED_Array(7,1,0x02);
        Set_LED_Array(5,2,0x02);
        Set_LED_Array(3,3,0x02);
        Set_LED_Array(4,3,0x02);
        Set_LED_Array(5,3,0x02);
        Set_LED_Array(6,3,0x02);
        Set_LED_Array(7,3,0x02);
        Set_LED_Array(5,4,0x02);
        Set_LED_Array(2,5,0x02);
        Set_LED_Array(3,5,0x02);
        Set_LED_Array(4,5,0x02);
        Set_LED_Array(5,5,0x02);
        Set_LED_Array(1,6,0x02);
        Set_LED_Array(5,6,0x02);
        Set_LED_Array(6,6,0x02);
        Set_LED_Array(2,7,0x02);
        Set_LED_Array(3,7,0x02);
        Set_LED_Array(4,7,0x02);
        Set_LED_Array(7,7,0x02);
        Set_LED2_Array(1,3,0x02);
        Set_LED2_Array(2,3,0x02);
        Set_LED2_Array(3,3,0x02);
        Set_LED2_Array(4,3,0x02);
        Set_LED2_Array(5,3,0x02);
        Set_LED2_Array(6,4,0x02);
        Set_LED2_Array(6,5,0x02);
        Set_LED2_Array(6,6,0x02);
        Set_LED2_Array(3,7,0x02);
        Set_LED2_Array(4,7,0x02);
        Set_LED2_Array(5,7,0x02);
        Set_LED3_Array(5,0,0x02);
        Set_LED3_Array(4,1,0x02);
        Set_LED3_Array(3,2,0x02);
        Set_LED3_Array(2,3,0x02);
        Set_LED3_Array(2,4,0x02);
        Set_LED3_Array(3,5,0x02);
        Set_LED3_Array(4,6,0x02);
        Set_LED3_Array(5,7,0x02);
        wait(1.5);
        myled = 1;
        myled2=1;
        Set_LED_Array(5,0,0x03);
        Set_LED_Array(2,1,0x03);
        Set_LED_Array(3,1,0x03);
        Set_LED_Array(4,1,0x03);
        Set_LED_Array(5,1,0x03);
        Set_LED_Array(6,1,0x03);
        Set_LED_Array(7,1,0x03);
        Set_LED_Array(5,2,0x03);
        Set_LED_Array(3,3,0x03);
        Set_LED_Array(4,3,0x03);
        Set_LED_Array(5,3,0x03);
        Set_LED_Array(6,3,0x03);
        Set_LED_Array(7,3,0x03);
        Set_LED_Array(5,4,0x03);
        Set_LED_Array(2,5,0x03);
        Set_LED_Array(3,5,0x03);
        Set_LED_Array(4,5,0x03);
        Set_LED_Array(5,5,0x03);
        Set_LED_Array(1,6,0x03);
        Set_LED_Array(5,6,0x03);
        Set_LED_Array(6,6,0x03);
        Set_LED_Array(2,7,0x03);
        Set_LED_Array(3,7,0x03);
        Set_LED_Array(4,7,0x03);
        Set_LED_Array(7,7,0x03);
        Set_LED2_Array(1,3,0x03);
        Set_LED2_Array(2,3,0x03);
        Set_LED2_Array(3,3,0x03);
        Set_LED2_Array(4,3,0x03);
        Set_LED2_Array(5,3,0x03);
        Set_LED2_Array(6,4,0x03);
        Set_LED2_Array(6,5,0x03);
        Set_LED2_Array(6,6,0x03);
        Set_LED2_Array(3,7,0x03);
        Set_LED2_Array(4,7,0x03);
        Set_LED2_Array(5,7,0x03);
        Set_LED3_Array(5,0,0x03);
        Set_LED3_Array(4,1,0x03);
        Set_LED3_Array(3,2,0x03);
        Set_LED3_Array(2,3,0x03);
        Set_LED3_Array(2,4,0x03);
        Set_LED3_Array(3,5,0x03);
        Set_LED3_Array(4,6,0x03);
        Set_LED3_Array(5,7,0x03);
        wait(1.5);
        
    }
}
