// MARMEX OLED and GPS test program
// Author : Yuji Notsu
// Date : 14-Jun-2011
// Revision : 0.0

/** A sample app of MARMEX_OB OLED screen drawing library
 *
 *  @author  Tedd
 *  @version 0.51
 *  @date    08-Apr-2011
 *
 *  Released under the MIT License: http://mbed.org/license/mit
 *
 *  MARMEX_OB_oled OLED screen drawing library for mbed
 *  This code has been written based on sample code and advises
 *    from Ochiai-san (Marutsu-Elec). Thank you!
 *
 *  To build this code, "NokiaLCD" and "mbed" libraries are needed to be imported in a project.
 *     NokiaLCD library :  http://mbed.org/users/simon/libraries/NokiaLCD/
 */


#include "mbed.h"
#include "MARMEX_OB_oled.h"
#include "imagedata.h"
#include "gpsrtc.h"
#include "TextLCD.h"
#include "SDFileSystem.h"
#include "PowerControl/EthernetPowerControl.h"

//  oled1 is for MARMEX_OB_oled board on MAPLE slot 1
MARMEX_OB_oled   oled1( p5, p7,  p8, p30, p11 ); // mosi, sclk, cs, rst, power_control

TextLCD lcd(p25,p24,p12,p13,p14,p23); //rs,e,d0-d3 

SDFileSystem sd(p5, p6, p7, p20, "sd"); // the pinout on the mbed Cool Components workshop board
Serial pc(USBTX, USBRX); // tx, rx

InterruptIn sendpcmode(p16);
InterruptIn oledmode(p17);

//AnalogIn ain(p19);
InterruptIn ain(p18);
DigitalOut led(LED3);

float sdata;
char pcmodevalue;
char oledmodevalue;
char graphnum=0;
float graph[16];
int c1,c2,c3,c4,c5,c6;
char c1en,c2en,c3en,c4en,c5en,c6en;
float maxdata;

void oled_image2(const unsigned int *ptr2);

void changepcmode()
{
    pcmodevalue=!pcmodevalue;
}

void changeoledmode()
{
    oledmodevalue=!oledmodevalue;
}

void count_geiger()
{
    led=1;
    if(c1en==1) c1++;
    if(c2en==1) c2++;
    if(c3en==1) c3++;
    if(c4en==1) c4++;
    if(c5en==1) c5++;
    if(c6en==1) c6++;
    led=0;
 } 

void setup_pinmode()
{
  //p25 lowlevel = write mode?
  sendpcmode.mode(PullUp);
  sendpcmode.rise(&changepcmode);
}

void setup_pinmode2()
{
    oledmode.mode(PullUp);
    oledmode.rise(&changeoledmode);
    for(int i=0;i<=15;i++)
    {
        graph[i]=0.0;
    }
}

void setup_pinmode3()
{
    ain.mode(PullNone);
    ain.rise(&count_geiger);
}


int main() {
    
    // Initialize RTC
    //
   // Init_RTC(1, 11, 05, 31, TUE, 00, 55, 00); // with adjustment
   //wait(1.0);
   // Init_RTC(0, 00, 00, 00, 000, 00, 00, 00); // without adjustment
   //
   
   PHY_PowerDown();
   
   pcmodevalue=0x00;
   oledmodevalue=0x00;
   graphnum=0;
   lcd.cls();
   lcd.locate(0,0);
   lcd.printf("Startup"); 
   pc.printf("Startup\n");
   sdata=0.0;
   
    //Start up window (texe base)
    oled1.background( 0x000000 );
    oled1.cls();
    oled1.locate(0,1);
    oled1.printf("Takoruka OS");
    oled1.locate(0,2);
    oled1.printf("starting.");
    wait(1.0);
    oled1.printf(".");
    wait(1.0);
    oled1.printf(".");
    wait(1.0);
    oled1.printf(".");
    wait(1.0);
    oled1.locate(0,3);
    oled1.printf("done!");
    
    c1=0;
    c2=0;
    c3=0;
    c4=0;
    c5=0;
    c6=0;
    //setup_pinmode();
    //setup_pinmode2();
    //setup_pinmode3();
      
    //display Imade data of imagedata.h 
    wait(1.0);
    oled1.cls();
    oled1.locate(0,0);
    oled_image2(Header1);
    
    wait(1.0);
    oled1.cls();
    
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("GPS Read start");
    pc.printf("GPS data read start\n");
    sGPSRTC sGPSRTC_Data;
    sGPSRTC *psGPSRTC_Data;
    
    int count = 0;
    c1en=1;
    c2en=0;
    c3en=0;
    c4en=0;
    c5en=0;
    c6en=0;
    setup_pinmode();
    setup_pinmode2();
    setup_pinmode3();
    
    pc.printf("Just into while loop\n");
    
    while(1)
    {
     //Get GPSRTC data and display
     if((count%10)==1)pc.printf("Just in while loop\n");
     Get_GPGGA_Data(&sGPSRTC_Data);
     Get_RTC_Data(&sGPSRTC_Data);
     psGPSRTC_Data = &sGPSRTC_Data;
     if((count%10)==1)pc.printf("while working\n");
     //Get sensor value
     //sdata = ain.read();
    
    //oled1.cls();
    
    if(oledmodevalue==0x01)
    {
     oled1.cls();
     oled1.locate(0,1);
     oled1.foreground(0xff00ff); 
     oled1.printf("RTC");
     oled1.locate(0,2);
     oled1.foreground(0x00ffff);
     oled1.printf("%02d/%02d/%02d(%s)",
                    psGPSRTC_Data->bRTC_year, psGPSRTC_Data->bRTC_mon, psGPSRTC_Data->bRTC_day,
                    Get_Week_String(psGPSRTC_Data->bRTC_week));
     oled1.locate(0,3);
     oled1.printf("%02d:%02d:%02d",
                    psGPSRTC_Data->bRTC_hour, psGPSRTC_Data->bRTC_min, psGPSRTC_Data->bRTC_sec); 
     oled1.locate(0,4);
     oled1.foreground(0xff0000);//Red
     oled1.printf("----------");
     oled1.foreground(0x00ffff);  //Cyan
     oled1.foreground(0xff00ff); 
     oled1.locate(0,5);
     oled1.printf("GPS");
     oled1.foreground(0xffff00); //Yellow
     oled1.locate(0,6);
     oled1.printf("UTC =");
     oled1.printf("%02d:%02d:%02d",
                    psGPSRTC_Data->bGPS_UTC_hour, psGPSRTC_Data->bGPS_UTC_min, psGPSRTC_Data->bGPS_UTC_sec);
     oled1.locate(0,7);
     //oled1.foreground(0x00ffff);  //Cyan
     oled1.printf("LAT =");
     oled1.printf("%c %02d:%02d:%02d", psGPSRTC_Data->cGPS_LAT,
                    psGPSRTC_Data->bGPS_LAT_deg, psGPSRTC_Data->bGPS_LAT_min, psGPSRTC_Data->bGPS_LAT_sec);
    oled1.foreground(0xffff00); //Yellow
    oled1.locate(0,8);
    oled1.printf("LNG =");
    oled1.printf("%c%03d:%02d:%02d", psGPSRTC_Data->cGPS_LNG,
                    psGPSRTC_Data->bGPS_LNG_deg, psGPSRTC_Data->bGPS_LNG_min, psGPSRTC_Data->bGPS_LNG_sec);
    oled1.locate(0,9);
    oled1.printf("Qual=");
    oled1.printf("%c     ", psGPSRTC_Data->cGPS_Quality);
    oled1.locate(0,10);
    oled1.foreground(0x00ffff);  //Cyan
    oled1.printf("Sat =");
    oled1.printf("%3d    ", psGPSRTC_Data->bGPS_Sat);
    oled1.locate(0,11);
    oled1.printf("HDOP=");
    oled1.printf("%1d.%1d    ", psGPSRTC_Data-> bGPS_HDOP_I, psGPSRTC_Data->bGPS_HDOP_D);
    oled1.locate(0,12);
    oled1.printf("ASL =");
    oled1.printf("%4dm", psGPSRTC_Data->wGPS_ASL_m);
    oled1.locate(0,13);
    oled1.printf("GEO =");
    oled1.printf("%4dm", psGPSRTC_Data->wGPS_GEO_m);
    }
    else //display sensor value (update 10sec)
    {
        
        switch(count)
        {
            case 0:
                c1en=0;
                sdata=c1;
                c1=0;
                c1en=1;
                break;
            case 10:
                c2en=0;
                sdata=c2;
                c2=0;
                c2en=1;
                break;
            case 20:
                c3en=0;
                sdata=c3;
                c3=0;
                c3en=1;
                break;
            case 30:
                c4en=0;
                sdata=c4;
                c4=0;
                c4en=1;
                break;
            case 40:
                c5en=0;
                sdata=c5;
                c5=0;
                c5en=1;
                break;
            case 50:
                c6en=0;
                sdata=c6;
                c6=0;
                c6en=1;
                break;
            default:
                sdata=sdata;
                break;
         }
        if(sdata>maxdata) maxdata=sdata;
        if((count%10)==1)
        {
            oled1.cls();
            float mSvh = float(sdata)/633.0;
            //float mSvh = float(sdata)/243.5;
            graphnum++;
            if(graphnum==16) graphnum=0;
            graph[graphnum]=sdata;
        
            for(int i=0;i<=15;i++)
            {
                int width = int(graph[i]/10); 
                if(i!=graphnum)
                    oled1.fill(i*8,28+(100-width),7,width,0xffff00);
                else
                    oled1.fill(i*8,28+(100-width),7,width,0xff00ff);
            }
            oled1.locate(0,1);
            oled1.foreground(0xff00ff); //Magenta
            oled1.printf("Sensor value");
            oled1.locate(0,2);
            oled1.foreground(0x00ffff); //Cyan
            oled1.printf("%4.1f max:%4.1f",sdata,maxdata);
            oled1.locate(0,3);
            oled1.printf("%7.4f [uSv/h]",mSvh);
        }    
    }
    
    count ++;

    if((count%10)==1)
    {
     FILE *fp=fopen("/sd/datalog.csv","a");
     if(fp==NULL)
     {
        error("Could not open file for write\n");
        pc.printf("Could not open file for write\n");
     }
     fprintf(fp,"UTC ,");
     fprintf(fp,"%02d:%02d:%02d ,",
                    psGPSRTC_Data->bRTC_hour, psGPSRTC_Data->bRTC_min, psGPSRTC_Data->bRTC_sec); 
     fprintf(fp,"LAT ,");
     fprintf(fp,"%c,%02d:%02d:%02d ,", psGPSRTC_Data->cGPS_LAT,
                    psGPSRTC_Data->bGPS_LAT_deg, psGPSRTC_Data->bGPS_LAT_min, psGPSRTC_Data->bGPS_LAT_sec);
     fprintf(fp,"LNG ,");
     fprintf(fp,"%c, %03d:%02d:%02d ,", psGPSRTC_Data->cGPS_LNG,
                    psGPSRTC_Data->bGPS_LNG_deg, psGPSRTC_Data->bGPS_LNG_min, psGPSRTC_Data->bGPS_LNG_sec);
     fprintf(fp,"Count,%4.2f \n",sdata);
     fclose(fp);
    }
    
     //Serial PC communication
     if((pcmodevalue==0x00)&&((count%10)==1))
     {
        pc.printf("UTC,");
         pc.printf("%02d:%02d:%02d ,",
                    psGPSRTC_Data->bRTC_hour, psGPSRTC_Data->bRTC_min, psGPSRTC_Data->bRTC_sec); 
        pc.printf("LAT,");
        pc.printf("%c,%02d:%02d:%02d ,", psGPSRTC_Data->cGPS_LAT,
                    psGPSRTC_Data->bGPS_LAT_deg, psGPSRTC_Data->bGPS_LAT_min, psGPSRTC_Data->bGPS_LAT_sec);
        pc.printf("LNG,");
        pc.printf("%c, %03d:%02d:%02d ,", psGPSRTC_Data->cGPS_LNG,
                    psGPSRTC_Data->bGPS_LNG_deg, psGPSRTC_Data->bGPS_LNG_min, psGPSRTC_Data->bGPS_LNG_sec);
    }
    if(count==60) count=0;
    
     wait(0.3);
     
    if((psGPSRTC_Data->bGPS_Sat)<=3)
    {
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Can't read GPS");
    } 
    else
    {
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("GPS data reading");
    }
    
    lcd.locate(0,1);
    lcd.printf("Count=%4.1f",sdata);
    if((pcmodevalue==0x00)&((count%10)==1))
    pc.printf("Count=%4.1f\n",sdata);
   
    }
    
    
}

void oled_image2(const unsigned int *ptr2)
{
   short height,width;
   int colour;
   height = *ptr2;
   ptr2++;
   width = *ptr2;
   ptr2++;
   oled1.locate(0,0);
   for(int i=1;i<=width;i++)
   {
    for(int j=1;j<=height;j++)
    {
       colour = (((*ptr2&0xF800)<<8) | ((*ptr2&0x07E0)<<5) | ((*ptr2&0x001F)<<3));
       oled1.pixel(j,i,colour);
        ptr2++;
    }
   }
}

/*
 *  history:
 *      0.5  (2011-Apr-07) :  initial published version
 *      0.51 (2011-Apr-08) :  minor modification to make the source more consistent (use " MARMEX_OB_oled::HEIGHT" instead of 128)
 */
