//=========================================================
// LPC1114 Project
//=========================================================
// File Name : gpsrtc.h
// Function  : GPS&RTC Control Header
//---------------------------------------------------------
// Rev.01 2010.08.29 Munetomo Maruyama
//---------------------------------------------------------
// Copyright (C) 2010-2011 Munetomo Maruyama
//=========================================================
// ---- License Information -------------------------------
// Anyone can FREELY use this code fully or partially
// under conditions shown below.
// 1. You may use this code only for individual purpose,
//    and educational purpose.
//    Do not use this code for business even if partially.
// 2. You should use this code under the GNU GPL.
// 3. You should remain this header text in your codes
//   including Copyright credit and License Information.
// 4. Your codes should inherit this license information.
//=========================================================
// ---- Patent Notice -------------------------------------
// I have not cared whether this system (hw + sw) causes
// infringement on the patent, copyright, trademark,
// or trade secret rights of others. You have all
// responsibilities for determining if your designs
// and products infringe on the intellectual property
// rights of others, when you use technical information
// included in this system for your business.
//=========================================================
// ---- Disclaimers ---------------------------------------
// The function and reliability of this system are not
// guaranteed. They may cause any damages to loss of
// properties, data, money, profits, life, or business.
// By adopting this system even partially, you assume
// all responsibility for its use.
//=========================================================

#ifndef __GPSRTC_H__
#define __GPSRTC_H__

//#include <type.h>

//=============
// GPSRTC Data
//=============
typedef struct
{
    unsigned char  bGPS_UTC_hour; // UTC hour
    unsigned char  bGPS_UTC_min;  // UTC minute
    unsigned char  bGPS_UTC_sec;  // UTC second
    unsigned char  cGPS_LAT;      // Latitude N or S
    unsigned char  bGPS_LAT_deg;  // Latitude degree
    unsigned char  bGPS_LAT_min;  // Latitude minute
    unsigned char  bGPS_LAT_sec;  // Latitude second
    unsigned char  cGPS_LNG;      // Longitude E or W
    unsigned char  bGPS_LNG_deg;  // Longitude degree
    unsigned char  bGPS_LNG_min;  // Longitude minute
    unsigned char  bGPS_LNG_sec;  // Longitude second
    unsigned char  cGPS_Quality;  // GPS Quality (0:Invalid, 1: SPS, 2:D-GPS)
    unsigned char  bGPS_Sat;      // Satellite Count
    unsigned char  bGPS_HDOP_I;   // Horizontal Dilution of Precision, Integer
    unsigned char  bGPS_HDOP_D;   // Horizontal Dilution of Precision, Decimal
    signed int  wGPS_ASL_m;    // Altitude above Sea Level in meter
    signed int  wGPS_GEO_m;    // Geoid Separation in meter
    //
    unsigned char  bRTC_year; // RTC year
    unsigned char  bRTC_mon;  // RTC month
    unsigned char  bRTC_day;  // RTC day
    unsigned char  bRTC_week; // RTC week
    unsigned char  bRTC_hour; // RTC hour
    unsigned char  bRTC_min;  // RTC minute
    unsigned char  bRTC_sec;  // RTC second
} sGPSRTC;

//===================
// Define Weekdays
//===================
enum WEEK {SUN = 0, MON, TUE, WED, THU, FRI, SAT};

//=============
// Prototypes
//=============
unsigned char* Get_Number_from_GPS(unsigned char *pStr,
        signed int *pInteger, signed int *pIntrnd, signed int *pDecimal, unsigned int *pDeclen);
void Get_GPGGA_Data(sGPSRTC *pG);
//
void Init_RTC(unsigned int do_adj, unsigned char year, unsigned char month,  unsigned char day,
              unsigned char week,    unsigned char hour, unsigned char minute, unsigned char second);
void Get_RTC_Data(sGPSRTC *psGPSRTC);
unsigned char *Get_Week_String(unsigned int week);
//
void RTC_Write_Reg(unsigned int addr, unsigned int data);
unsigned int RTC_Read_Reg(unsigned int addr);
unsigned char BCD_INT(unsigned char num);
signed int power(signed int x, signed int n);
unsigned char INT_BCD(unsigned char bcd);

#endif // __GPSRTC_H__

//=========================================================
// End of Program
//=========================================================