// MARMEX OLED and GPS test program
// Author : Yuji Notsu
// Date : 30-Mar-2011
// Revision : 0.0

/** A sample app of MARMEX_OB OLED screen drawing library
 *
 *  @author  Tedd
 *  @version 0.51
 *  @date    08-Apr-2011
 *
 *  Released under the MIT License: http://mbed.org/license/mit
 *
 *  MARMEX_OB_oled OLED screen drawing library for mbed
 *  This code has been written based on sample code and advises
 *    from Ochiai-san (Marutsu-Elec). Thank you!
 *
 *  To build this code, "NokiaLCD" and "mbed" libraries are needed to be imported in a project.
 *     NokiaLCD library :  http://mbed.org/users/simon/libraries/NokiaLCD/
 */


#include "mbed.h"
#include "MARMEX_OB_oled.h"
#include "imagedata.h"
#include "gpsrtc.h"

//  oled1 is for MARMEX_OB_oled board on MAPLE slot 1
MARMEX_OB_oled   oled1( p5, p7,  p8, p30, p11 ); // mosi, sclk, cs, rst, power_control

void oled_image2(const unsigned int *ptr2);

int main() {
    
    // Initialize RTC
    //
   // Init_RTC(1, 11, 05, 31, TUE, 00, 55, 00); // with adjustment
   //wait(1.0);
   // Init_RTC(0, 00, 00, 00, 000, 00, 00, 00); // without adjustment
    //
    
    //Start up window (texe base)
    oled1.background( 0x000000 );
    oled1.cls();
    oled1.locate(0,1);
    oled1.printf("Takoruka OS");
    oled1.locate(0,2);
    oled1.printf("starting.");
    wait(1.0);
    oled1.printf(".");
    wait(1.0);
    oled1.printf(".");
    wait(1.0);
    oled1.printf(".");
    wait(1.0);
    oled1.locate(0,3);
    oled1.printf("done!");
    
    //display Imade data of imagedata.h 
    wait(1.0);
    oled1.cls();
    oled1.locate(0,0);
    oled_image2(Header1);
    
    wait(1.0);
    oled1.cls();
    
    sGPSRTC sGPSRTC_Data;
    sGPSRTC *psGPSRTC_Data;
    
    while(1)
    {
     //Get GPSRTC data and display
     Get_GPGGA_Data(&sGPSRTC_Data);
     Get_RTC_Data(&sGPSRTC_Data);
     psGPSRTC_Data = &sGPSRTC_Data;

     oled1.locate(0,1);
     oled1.foreground(0xff00ff); 
     oled1.printf("RTC");
     oled1.locate(0,2);
     oled1.foreground(0x00ffff);
     oled1.printf("%02d/%02d/%02d(%s)",
                    psGPSRTC_Data->bRTC_year, psGPSRTC_Data->bRTC_mon, psGPSRTC_Data->bRTC_day,
                    Get_Week_String(psGPSRTC_Data->bRTC_week));
     oled1.locate(0,3);
     oled1.printf("%02d:%02d:%02d",
                    psGPSRTC_Data->bRTC_hour, psGPSRTC_Data->bRTC_min, psGPSRTC_Data->bRTC_sec); 
     oled1.locate(0,4);
     oled1.foreground(0xff0000);//Red
     oled1.printf("----------");
     oled1.foreground(0x00ffff);  //Cyan
     oled1.foreground(0xff00ff); 
     oled1.locate(0,5);
     oled1.printf("GPS");
     oled1.foreground(0xffff00); //Yellow
     oled1.locate(0,6);
     oled1.printf("UTC =");
     oled1.printf("%02d:%02d:%02d",
                    psGPSRTC_Data->bGPS_UTC_hour, psGPSRTC_Data->bGPS_UTC_min, psGPSRTC_Data->bGPS_UTC_sec);
     oled1.locate(0,7);
     //oled1.foreground(0x00ffff);  //Cyan
     oled1.printf("LAT =");
     oled1.printf("%c %02d:%02d:%02d", psGPSRTC_Data->cGPS_LAT,
                    psGPSRTC_Data->bGPS_LAT_deg, psGPSRTC_Data->bGPS_LAT_min, psGPSRTC_Data->bGPS_LAT_sec);
    oled1.foreground(0xffff00); //Yellow
    oled1.locate(0,8);
    oled1.printf("LNG =");
    oled1.printf("%c%03d:%02d:%02d", psGPSRTC_Data->cGPS_LNG,
                    psGPSRTC_Data->bGPS_LNG_deg, psGPSRTC_Data->bGPS_LNG_min, psGPSRTC_Data->bGPS_LNG_sec);
    oled1.locate(0,9);
    oled1.printf("Qual=");
    oled1.printf("%c     ", psGPSRTC_Data->cGPS_Quality);
    oled1.locate(0,10);
    oled1.foreground(0x00ffff);  //Cyan
    oled1.printf("Sat =");
    oled1.printf("%3d    ", psGPSRTC_Data->bGPS_Sat);
    oled1.locate(0,11);
    oled1.printf("HDOP=");
    oled1.printf("%1d.%1d    ", psGPSRTC_Data-> bGPS_HDOP_I, psGPSRTC_Data->bGPS_HDOP_D);
    oled1.locate(0,12);
    oled1.printf("ASL =");
    oled1.printf("%4dm", psGPSRTC_Data->wGPS_ASL_m);
    oled1.locate(0,13);
    oled1.printf("GEO =");
    oled1.printf("%4dm", psGPSRTC_Data->wGPS_GEO_m);
     wait(0.3);
   
    }
    
    
}

void oled_image2(const unsigned int *ptr2)
{
   short height,width;
   int colour;
   height = *ptr2;
   ptr2++;
   width = *ptr2;
   ptr2++;
   oled1.locate(0,0);
   for(int i=1;i<=width;i++)
   {
    for(int j=1;j<=height;j++)
    {
       colour = (((*ptr2&0xF800)<<8) | ((*ptr2&0x07E0)<<5) | ((*ptr2&0x001F)<<3));
       oled1.pixel(j,i,colour);
        ptr2++;
    }
   }
}

/*
 *  history:
 *      0.5  (2011-Apr-07) :  initial published version
 *      0.51 (2011-Apr-08) :  minor modification to make the source more consistent (use " MARMEX_OB_oled::HEIGHT" instead of 128)
 */
