#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"

 
EthernetNetIf eth(
    IpAddr(192,168,1,8), //IP address
    IpAddr(255,255,255,0), //Subnet mask
    IpAddr(192,168,1,1), //Gateway
    IpAddr(192,168,1,1)  //DNS
    );  
HTTPServer svr;
 
DigitalOut led1(LED1);
DigitalOut led2(LED2,"led2");
LocalFileSystem fs("webfs");
SPI spi(p5, p6, p7); // mosi, miso, sclk
DigitalOut cs(p8);
float Intempareture,Outtempareture;
 
int main() {
  printf("Setting up...\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("Setup OK\n");
  
  FSHandler::mount("/webfs","/");
  svr.addHandler<RPCHandler>("/rpc");
  svr.addHandler<FSHandler>("/");
  //svr.addHandler<SimpleHandler>("/"); //Default handler
  svr.bind(80);
  
  printf("Listening...\n");
    
  Timer tm;
  tm.start();
  //Listen indefinitely
  
  // Setup the spi for 8 bit data, high steady state clock,
  // second edge capture, with a 1MHz clock rate
  spi.format(16,3);
  spi.frequency(1000000);
  
  while(true)
  {
    Net::poll();
    if(tm.read()>.5)
    {
      led1=!led1; //Show that we are alive
      tm.start();
    }
    // Select the device by seting chip select low
    cs = 0;
 
    // Send 0x8f, the command to read the WHOAMI register
    //spi.write(0x0000);
    
    // Send a dummy byte to receive the contents of the WHOAMI register
    int outtemp = spi.write(0x0000);
    int intemp = spi.write(0x0000);
    //printf("outtemp  = 0x%X\n", outtemp);
    //lcd.locate(0,0);
    //lcd.printf("Out:0x%X\n",outtemp);
    //printf("intemp = 0x%X\n", intemp);
    //lcd.locate(0,1);
    //lcd.printf("In :0x%X",intemp);
    // Deselect the device
    cs = 1;
    float disp;
    if((outtemp& 0x8000) == 0){ // 0℃以上
      disp = (outtemp >> 4) * 0.0625;
    } else {                          // 0℃未満
      disp = (((0xffff - outtemp) >> 4) + 1)  * -0.0625;
    }
    Outtempareture=disp;
    printf("Out:%4.2f[deg]\n",disp);
    
    if((intemp& 0x8000) == 0){ // 0℃以上
      disp = (intemp>> 4) * 0.0625;
    } else {                          // 0℃未満
      disp = (((0xffff - intemp) >> 4) + 1)  * -0.0625;
    }
    Intempareture=disp;
    printf("In:%4.2f[deg]\n",disp);
    //HTML File output
    FILE *fp=fopen("/webfs/my.htm","w");
    fprintf(fp,"<html>\r\n");
    fprintf(fp, "<head>\r\n");
    fprintf(fp, "<title>\r\n");
    fprintf(fp, "LED2 ON/OF\r\n");
    fprintf(fp, "</title>\r\n");
    fprintf(fp, "</head>\r\n");
    fprintf(fp, "<body>\r\n");
    /*
    fprintf(fp, "<script language=\"javascript\">\n");
    fprintf(fp, "var Button=0; \n");
    fprintf(fp, "function button_push(flug){\n");
    fprintf(fp, "if(Button==0){ Button=1;document.Form.FormButton.value=\"Off\";}\n");
    fprintf(fp, "else{ Button=0; document.Form.FormButton.value=\"On\"; } \n");
    fprintf(fp, "var req=new XMLHttpRequest()\n");
    fprintf(fp, "req.open(\"GET\", \"http://\"+location.host+\"/rpc/led2/write+\"+Button. true); \n");
    fprintf(fp, "req.send(\"\"); \n");
    fprintf(fp, "function tick(){ \n");
    fprintf(fp, "var value=%f;\n",Outtempareture);
    fprintf(fp, "document.Form.textbox.value=value;\n");
    fprintf(fp, "var value2=%f;\n",Intempareture);
    fprintf(fp, "document.Form.textbox2.value=value2;\n"); 
    fprintf(fp, "}\n");
    fprintf(fp, "setInterval(\"tick()\",1000);\n");
    fprintf(fp, "</script>\n");
    */
    
    //fprintf(fp, "<form name=\"Form\" action=\"#\"> \n");
    fprintf(fp, "<font size=5>\n");
    fprintf(fp, "My room Tempareture\n");
    //fprintf(fp, "<input type=\"button\" value=\"On\" name=\"FormButton\" onclick=\"button_push(0)\">\n");
    fprintf(fp, "<br>\n");
    fprintf(fp, "Out temp:\n");
    fprintf(fp, "<font size=8><b>\n");
    fprintf(fp, "%5.2f\n",Outtempareture);
    fprintf(fp, "</b></font>\n");
    fprintf(fp, "<br>\n");
    fprintf(fp, "In temp:\n");
    fprintf(fp, "<font size=8><b>\n");
    fprintf(fp, "%5.2f\n",Intempareture);
    fprintf(fp, "</b></font>\n");
    fprintf(fp, "<br>\n");
    fprintf(fp, "<hr>\n");
    fprintf(fp, "</font>\n");
    fprintf(fp, " Twitter: <a href=\"https://twitter.com/ynotsu\">@ynotsu</a>");
    fprintf(fp, "</body>\n");
    fprintf(fp, "</html>\n");
    fclose(fp);
    
    //wait(10);
    
  }
  
  return 0;
}