#include "mbed.h"
#include "SerialLCD.h"

DigitalOut myled(P0_9);
DigitalOut Buzzer(P0_7);
Serial LCD(P0_4, P0_0); //tx, rx
DigitalOut Relay(P0_12);

void ClearDisplay()
{
    LCD.putc(SLCD_CONTROL_HEADER);
    LCD.putc(SLCD_CLEAR_DISPLAY);
}

void LCDHome()
{
    LCD.putc(SLCD_CONTROL_HEADER);
    LCD.putc(SLCD_RETURN_HOME);
}

void LCDsetCursor(uint8_t column, uint8_t row)
{
    LCD.putc(SLCD_CONTROL_HEADER);
    LCD.putc(SLCD_CURSOR_HEADER);
    LCD.putc(column);
    LCD.putc(row);
}

// Switch the display off without clearing RAM
void LCDnoDisplay()
{
    LCD.putc(SLCD_CONTROL_HEADER);
    LCD.putc(SLCD_DISPLAY_OFF); 
}

// Switch the display on
void LCDdisplay() 
{
    LCD.putc(SLCD_CONTROL_HEADER);
    LCD.putc(SLCD_DISPLAY_ON);    
}

// Switch the underline cursor off
void LCDnoCursor() 
{
    LCD.putc(SLCD_CONTROL_HEADER);
    LCD.putc(SLCD_CURSOR_OFF);     
}

// Switch the underline cursor on
void LCDcursor() 
{
    LCD.putc(SLCD_CONTROL_HEADER);
    LCD.putc(SLCD_CURSOR_ON);     
}

//Turn off the backlight
void LCDnoBacklight(void)
{
    LCD.putc(SLCD_CONTROL_HEADER);   
    LCD.putc(SLCD_BACKLIGHT_OFF);   
}
//Turn on the back light
void LCDbacklight(void)
{
    LCD.putc(SLCD_CONTROL_HEADER);   
    LCD.putc(SLCD_BACKLIGHT_ON);   
}

void LCDprint(uint8_t b)
{
    LCD.putc(SLCD_CHAR_HEADER);
    LCD.putc(b);
}

void LCDprintc(const char b[])
{
    LCD.putc(SLCD_CHAR_HEADER);
    LCD.printf(b);
}    
    

int main() {
    LCD.baud(9600);
    //LCD startup
    LCD.putc(SLCD_CONTROL_HEADER);
    LCD.putc(SLCD_POWER_OFF);
    wait_ms(1);
    LCD.putc(SLCD_CONTROL_HEADER);
    LCD.putc(SLCD_POWER_ON);
    wait_ms(1);
    LCD.putc(SLCD_INIT_ACK);
    while(1)
    {
        if(LCD.getc()==SLCD_INIT_DONE)
        break;
    }
    wait_ms(2);
    
    //LCD printf
    LCDprintc("Hello World");
    
    //LCD Backlight ON
    LCDbacklight();
    
    //LCD Display ON
    LCDdisplay();
    
    while(1) {
        LCDnoBacklight();
        myled = 1;
        Buzzer=0;
        Relay=1;
        wait(0.2);
        LCDbacklight();
        myled = 0;
        Buzzer=1;
        Relay=0;
        wait(0.2);
    }
}
