#include "RationalNum.h"

int gcd(int x, int y){
  if(!x)return y;
  while(y){
    if(x>y)x=x-y;
    else y=y-x;
  }
  return x;
}

int lcm(int x, int y){
  return x*y/gcd(x,y);
}

RationalNum operator + (RationalNum lhs, RationalNum rhs){
  int l = lcm(lhs.denominator, rhs.denominator);
  int c1 = l/lhs.denominator, c2 = l/rhs.denominator;
  int n = c1*lhs.numerator+c2*rhs.numerator;
  int g = (n>=0) ? gcd(n,l):gcd(0-n, l);
  return RationalNum(n/g, l/g);
}

RationalNum operator - (RationalNum lhs, RationalNum rhs){
  int l = lcm(lhs.denominator, rhs.denominator);
  int c1 = l/lhs.denominator, c2 = l/rhs.denominator;
  int n = c1*lhs.numerator-c2*rhs.numerator;
  int g = (n>=0) ? gcd(n,l):gcd(0-n, l);
  return RationalNum(n/g, l/g);
}

RationalNum operator * (RationalNum lhs, RationalNum rhs){
  int n = 0, d = 0, g = 0;
  n = lhs.numerator * rhs.numerator;
  d = lhs.denominator * rhs.denominator;
  g = (n>=0) ? gcd(n, d):gcd(0-n,d);
  return RationalNum(n/g, d/g); 
}

RationalNum operator / (RationalNum lhs, RationalNum rhs){
  int n = 0, d = 0, g = 0;
  n = lhs.numerator * rhs.denominator;
  d = lhs.denominator * rhs.numerator;
  if(d<0){
    d = 0 - d;
    n = 0 - n;
  }
  g = (n>=0) ? gcd(n, d):gcd(0-n,d);
  return RationalNum(n/g, d/g); 
}

bool operator == (RationalNum lhs, RationalNum rhs){
  return ((lhs.numerator==rhs.numerator) && (lhs.denominator==rhs.denominator)); 
}

bool operator != (RationalNum lhs, RationalNum rhs){
  return ((lhs.numerator!=rhs.numerator) || (lhs.denominator!=rhs.denominator));
}

bool operator >= (RationalNum lhs, RationalNum rhs){
  int l = lcm(lhs.denominator, rhs.denominator);
  int c1 = l/lhs.denominator, c2 = l/rhs.denominator;
  int n = c1*lhs.numerator-c2*rhs.numerator;
  return n>=0;
}

bool operator > (RationalNum lhs, RationalNum rhs){
  int l = lcm(lhs.denominator, rhs.denominator);
  int c1 = l/lhs.denominator, c2 = l/rhs.denominator;
  int n = c1*lhs.numerator-c2*rhs.numerator;
  return n>0;
}

bool operator <= (RationalNum lhs, RationalNum rhs){
  int l = lcm(lhs.denominator, rhs.denominator);
  int c1 = l/lhs.denominator, c2 = l/rhs.denominator;
  int n = c1*lhs.numerator-c2*rhs.numerator;
  return n<=0;
}

bool operator < (RationalNum lhs, RationalNum rhs){
  int l = lcm(lhs.denominator, rhs.denominator);
  int c1 = l/lhs.denominator, c2 = l/rhs.denominator;
  int n = c1*lhs.numerator-c2*rhs.numerator;
  return n<0;
}

void RationalNum::normalize(){
  if(denominator==0){
    error("denominator must be non-zero\r\n");
    exit(1);
  }else if(numerator==0){
    numerator = 0;
    denominator = 1;
  }else if(denominator<0){
    numerator = 0 - numerator;
    denominator = 0 - denominator;
  }
  else{
    return;
  }
}