#ifndef MOTION_TRACKING_H_
#define MOTION_TRACKING_H_

#include "mbed.h"
#include "FXOS8700.h"
#include "FXAS21002.h"
#include "math.h"
#include "stdio.h"

#define MAINWAIT 1
#define CALIBTIMES 50
#define SAMPLEPERIOD_S 6
#define MOVINGAVRBUFSIZE 40
#define MOVINGENDBUFSIZE 32
#define TRENDPROTECTBUFSIZE 70
#define YMOVENDTHRESHOLD 0.1
#define ZMOVENDTHRESHOLD 0.1
#define YMOVENDBIASNUM 30
#define ZMOVENDBIASNUM 30
#define XTRENDPROTECTTHRESHOLD 0.06
#define YTRENDPROTECTTHRESHOLD 0.06
#define MAXBUFFERSIZE 3000
#define XMECHANICAL 0.005
#define YMECHANICAL 0.005
#define ZMECHANICAL 0.005
#define VERTICALNUMCOLOR 3
#define HORIZONTALNUMCOLOR 5

struct RGB {
    int R;
    int G;
    int B;
};

void acquire_new_speed(float *cur_speed, float duration, float *instant_accel);

void acquire_sensor_data(float *accel_data, float *gyro_data, float *calib_data,
                         int calibFlag, FXOS8700 *accel, FXAS21002 *gyro);

void get_caliberate_data(float *caliberate, FXOS8700 *accel, FXAS21002 *gyro);

void load_buffer(float **all_data, float *accel_data, float time, int i);

void init_moving_avg_buf(float moving_avg_buf[][MOVINGAVRBUFSIZE], int *num_samples, 
                         float *last_total, float **all_data, float *caliberate, 
                         Timer *t, FXOS8700 *accel, FXAS21002 *gyro);

void get_new_moving_average_point(float **all_data, float *last_total, 
                                float *accel_data, float moving_avg_buf[][MOVINGAVRBUFSIZE], 
                                float time, int *num_samples, int *start, 
                                int *end);

void apply_trend_protect(float **all_data, int num_samples, float *total_diff,
                        float *additional_to_vel, float duration);

void apply_move_end_check(float **all_data, int num_samples, 
                        int moving_end_buf[][MOVINGENDBUFSIZE],
                        int *num_unqualified, int *start, int *end,
                        float *addition_to_vel, float duration,
                        float *total_diff);

void get_new_velocity (float *original_speed, float *addition_to_vel);

void get_new_position (float *original_position, float *cur_speed, float duration);

void insert_new_vel_to_buffer(float** vel_buffer, float time, float* cur_vel,
                              int num_samples);

void insert_new_pos_to_buffer(float** pos_buffer, float time, float* cur_pos,
                              int num_samples);

void insert_new_color_to_buffer(float **color_buffer, int r, int g, int b, 
                                float time, int num_samples);

void initialize_color_table(RGB rgb_table[][HORIZONTALNUMCOLOR]);

RGB get_new_color(float *cur_location, RGB rgb_table[][HORIZONTALNUMCOLOR]);

void output_all_to_serial(float **all_data, int num_samples);

void output_color_to_serial(float **color_data, int num_samples);

void output_to_serial(float **vel_data, int num_samples);

#endif
