#include "mbed.h"
#include "TextLCD.h"
DigitalInOut data_pin(p6); // Activate digital in as dht11 Pin
DigitalOut pin5(p5); // Switch the fan on and off
TextLCD lcd(p10, p12, p15, p16, p29, p30); // rs, e, d4-d7
Timer tmr; //initialize timer
uint64_t adat; // 64 bit variable for temporary data
int i;
void dht_read(void) {
    data_pin.output(); // Set p6 as output
    // Initialize measurement > 18 ms low
    data_pin = 0;
    wait_ms(20);
    // After high and release the pin switch input mode
    data_pin = 1;
    data_pin.input();
    // Wait until the end of 80 us low
    while(!data_pin.read()) {}
    // Wait until end of 80 us high
    while(data_pin.read()) {}
    // 40 bit, 40 read out cycle
    for(i=0; i<40; i++) {
        adat = adat << 1; // Shift for new number
        tmr.stop(); // Stop timer if runs
        tmr.reset();  // Reset timer
        // Wait until pin
        while(!data_pin.read()) {}          
        tmr.start();            
        while(data_pin.read()) {}
        // If DHT11 HIGH longer than 40 micro seconds (hopefully 70 us)
        if(tmr.read_us() > 40) {
            // bit is 1
            adat++;
        }
    }
}
int main() {
    while(1) {
            adat = 0;
            dht_read(); // Call the function   
            int abc = (adat & 0x0000000000ff0000) >> 16;            
            lcd.printf("Temperature:\n");
            lcd.printf("%d",abc);     // Temperature       
            if(abc > 20) pin5 = 1;   // Fan is ON
            else pin5 = 0;   //Fan is OFF
            wait(2); // Wait 2 sec till continue.
            lcd.cls(); // Clear the screen
    }
}