/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
 
 /*
#include "mbed_assert.h"
#include "analogin_api.h"
#include "cmsis.h"
#include "pinmap.h"
#include "nrf_drv_adc.h"

#ifdef DEVICE_ANALOGIN


#define ADC_10BIT_RANGE  0x3FF
#define ADC_RANGE        ADC_10BIT_RANGE

static const PinMap PinMap_ADC[] = {
    {p1, ADC0_0, 4},
    {p2, ADC0_0, 8},
    {p3, ADC0_0, 16},
    {p4, ADC0_0, 32},
    {p5, ADC0_0, 64},
    {p6, ADC0_0, 128},
#ifndef TARGET_NRF51_DONGLE
    {p26, ADC0_0, 1},
    {p27, ADC0_0, 2},
#endif
    {NC, NC, 0}
};


void analogin_init(analogin_t *obj, PinName pin)
{
    obj->adc = (ADCName)pinmap_peripheral(pin, PinMap_ADC);
    MBED_ASSERT(obj->adc != (ADCName)NC);

    uint32_t pinFunc = pinmap_function(pin, PinMap_ADC);
    MBED_ASSERT(pinFunc != (uint32_t)NC);
    
    obj->adc_pin =  pinFunc;
    
    ret_code_t ret_code;
                                              // p_config, event_handler
    ret_code = nrf_drv_adc_init(NULL , NULL); // select blocking mode
    MBED_ASSERT((ret_code == NRF_SUCCESS) || (ret_code == NRF_ERROR_INVALID_STATE)); //NRF_ERROR_INVALID_STATE expected for multiple channels used.
}

uint16_t analogin_read_u16(analogin_t *obj)
{
    nrf_adc_value_t adc_value;
       
    nrf_drv_adc_channel_t adc_channel;
    
    // initialization by assigment because IAR dosen't support variable initializer in declaration statement.
    adc_channel.config.config.resolution = NRF_ADC_CONFIG_RES_10BIT;
    adc_channel.config.config.input      = NRF_ADC_CONFIG_SCALING_INPUT_FULL_SCALE;
    adc_channel.config.config.reference  = NRF_ADC_CONFIG_REF_VBG;
    adc_channel.config.config.ain        = (obj->adc_pin);
    adc_channel.p_next = NULL;
    

    ret_code_t ret_code;
    
    ret_code = nrf_drv_adc_sample_convert( &adc_channel, &adc_value);
    MBED_ASSERT(ret_code == NRF_SUCCESS);
    
    return adc_value;
}

float analogin_read(analogin_t *obj)
{
    uint16_t value = analogin_read_u16(obj);

    return (float)value * (1.0f / (float)ADC_RANGE);
}

#endif // DEVICE_ANALOGIN
*/

/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "mbed_assert.h"
#include "analogin_api.h"
#include "cmsis.h"
#include "pinmap.h"


#ifdef DEVICE_ANALOGIN


#define ANALOGIN_MEDIAN_FILTER      1
#define ADC_10BIT_RANGE             0x3FF
#define ADC_RANGE    ADC_10BIT_RANGE

static const PinMap PinMap_ADC[] = {
    {p1, ADC0_0, 4},
    {p2, ADC0_0, 8},
    {p3, ADC0_0, 16},
    {p4, ADC0_0, 32},
    {p5, ADC0_0, 64},
    {p6, ADC0_0, 128},
#ifndef TARGET_NRF51_DONGLE
    {p26, ADC0_0, 1},
    {p27, ADC0_0, 2},
#endif
    {NC, NC, 0}
};

void analogin_init(analogin_t *obj, PinName pin)
{
    int analogInputPin = 0;
    const PinMap *map  = PinMap_ADC;

    obj->adc = (ADCName)pinmap_peripheral(pin, PinMap_ADC); //(NRF_ADC_Type *)
    MBED_ASSERT(obj->adc != (ADCName)NC);

    while (map->pin != NC) {
        if (map->pin == pin) {
            analogInputPin = map->function;
            break;
        }
        map++;
    }
    obj->adc_pin = (uint8_t)analogInputPin;
    NRF_ADC->CONFIG = (ADC_CONFIG_RES_10bit << ADC_CONFIG_RES_Pos) |
                      (ADC_CONFIG_INPSEL_AnalogInputOneThirdPrescaling << ADC_CONFIG_INPSEL_Pos) |
                      (ADC_CONFIG_REFSEL_SupplyOneThirdPrescaling << ADC_CONFIG_REFSEL_Pos) |
                      (analogInputPin << ADC_CONFIG_PSEL_Pos) |
                      (ADC_CONFIG_EXTREFSEL_None << ADC_CONFIG_EXTREFSEL_Pos);
}

uint16_t analogin_read_u16(analogin_t *obj)
{
    NRF_ADC->ENABLE = ADC_ENABLE_ENABLE_Enabled;
    NRF_ADC->CONFIG     &= ~ADC_CONFIG_PSEL_Msk;
    NRF_ADC->CONFIG     |= obj->adc_pin << ADC_CONFIG_PSEL_Pos;
    NRF_ADC->EVENTS_END  = 0;
    NRF_ADC->TASKS_START = 1;

    while (!NRF_ADC->EVENTS_END) {
    }

    NRF_ADC->ENABLE = ADC_ENABLE_ENABLE_Disabled;
    return (uint16_t)NRF_ADC->RESULT; // 10 bit
}

float analogin_read(analogin_t *obj)
{
    uint16_t value = analogin_read_u16(obj);
    return (float)value * (1.0f / (float)ADC_RANGE);
}



void battery_init(analogin_t *obj){

    // Use internal 1.2V reference for batteryInput
    //  1/3 pre-scaled input and 1.2V internal band gap reference
    // ref. mbed-src/targets/hal/TARGET_NORDIC/TARGET_MCU_NRF51822/analogin_api.c
    NRF_ADC->CONFIG =
        (ADC_CONFIG_RES_10bit << ADC_CONFIG_RES_Pos) |
        (ADC_CONFIG_INPSEL_SupplyOneThirdPrescaling << ADC_CONFIG_INPSEL_Pos) |
        (ADC_CONFIG_REFSEL_VBG << ADC_CONFIG_REFSEL_Pos) |
        (ADC_CONFIG_EXTREFSEL_None << ADC_CONFIG_EXTREFSEL_Pos);
}


uint16_t battery_read_u16(analogin_t *obj){
    NRF_ADC->ENABLE = ADC_ENABLE_ENABLE_Enabled;
    NRF_ADC->EVENTS_END  = 0;
    NRF_ADC->TASKS_START = 1;
    while (!NRF_ADC->EVENTS_END) {
    }
    NRF_ADC->ENABLE = ADC_ENABLE_ENABLE_Disabled;
    return (uint16_t)NRF_ADC->RESULT; // 10 bit
}

#endif // DEVICE_ANALOGIN