#ifndef VS1053_H
#define VS1053_H

#define FIXED_VOL

// the following two is exclusive use
#define VS_PATCH
//#define VS_SPECANA

#include "mbed.h"
//#include "SDFileSystem.h"
#include "string"
#include "string.h"

// SCI register address assignment
#define SCI_MODE    0x0
#define SCI_STATUS  0x1
#define SCI_BASS    0x2
#define SCI_CLOCKF  0x3
#define SCI_DECODE_TOME 0x4
#define SCI_AUDATA  0x5
#define SCI_WRAM    0x6
#define SCI_WRAMADDR 0x7
#define SCI_HDAT0   0x8
#define SCI_HDAT1   0x9
#define SCI_AIADDR  0xA
#define SCI_VOL     0xB
#define SCI_AICTRL0 0xC
#define SCI_AICTRL1 0xD
#define SCI_AICTRL2 0xE
#define SCI_AICTRL3 0xF


//SCI_MODE register bits as of p.38 of the datasheet
#define SM_DIFF         0x0001
#define SM_LAYER12      0x0002
#define SM_RESET        0x0004
#define SM_CANCEL       0x0008
#define SM_EARSPEAKER_LO 0x0010
#define SM_TESTS        0x0020
#define SM_STREAM       0x0040
#define SM_EARSPEAKER_HI 0x0080
#define SM_DACT         0x0100
#define SM_SDIORD       0x0200
#define SM_SDISHARE     0x0400
#define SM_SDINEW       0x0800
#define SM_ADPCM        0x1000
#define SM_B13          0x2000
#define SM_LINE1        0x4000
#define SM_CLK_RANGE    0x8000

//SCI_CLOCKF register bits as of p.42 of the datasheet
#define SC_MULT_XTALI    0x0000
#define SC_MULT_XTALIx20 0x2000
#define SC_MULT_XTALIx25 0x4000
#define SC_MULT_XTALIx30 0x6000
#define SC_MULT_XTALIx35 0x8000
#define SC_MULT_XTALIx40 0xA000
#define SC_MULT_XTALIx45 0xC000
#define SC_MULT_XTALIx50 0xE000
//
#define SC_ADD_NOMOD 0x0000
#define SC_ADD_10x   0x0800
#define SC_ADD_15x   0x1000
#define SC_ADD_20x   0x1800


// Extra Parameter in X memory (refer to p.58 of the datasheet)
#define para_chipID_0   0x1E00
#define para_chipID_1   0x1E01
#define para_version    0x1E02
#define para_config1    0x1E03
#define para_playSpeed  0x1E04
#define para_byteRate   0x1E05
#define para_endFillByte    0x1E06
//
#define para_positionMsec_0 0x1E27
#define para_positionMsec_1 0x1E28
#define para_resync         0x1E29


class VS1053  {

public:
    VS1053(
    //PinName _mmosi, PinName _mmiso, PinName _ssck, PinName _ccs, const char* _name, 
    PinName _mosi, PinName _miso, PinName _sck, PinName _cs, PinName _rst, PinName _dreq,
    PinName _dcs, PinName _vol);
    
    void cs_low(void); 
    void cs_high(void);
    void dcs_low(void);
    void dcs_high(void);
    void sci_en(void);
    void sci_dis(void);
    void sdi_en(void);
    void sdi_dis(void);
    
    void sci_initialise(void);
    void sdi_initialise(void);
    void reset(void);
    void power_down(void);
 
    void sci_write(unsigned char, unsigned short int);
    void sdi_write(unsigned char);
    unsigned short int sci_read(unsigned short int);
    void sine_test_activate(unsigned char);
    void volume(void);
    void sine_test_deactivate(void);
    void writeStream(unsigned char *, int);
#if 0
    void putcStream(unsigned char);
#endif
    void terminateStream(void);
//    void write_plugin(const unsigned short *, unsigned int);
    void initialize(void);
       
    DigitalIn _DREQ;
    DigitalOut _RST;
    AnalogIn _VOL;
    
protected:
    unsigned short int wram_read(unsigned short int);
    void wram_write(unsigned short int, unsigned short int);
    void write_plugin(const unsigned short *, unsigned int);
    SPI _spi;
    DigitalOut _CS;
    DigitalOut _DCS;
    int firstTime;

};
#endif
