//
// mbeduino MP3 Shield Player
//
// Note: 
//  (1)Push reset button on the MP3 Sheild to reboot
//   when this program does not work correctly.
//  (2)Remenber the file system does not support long file/directory name.
//  (3)I have confirmed MP3,Ogg,MIDI,WMA,FLAC,AAC work correcly. (FLAC needs patch)
//   WAV needs data transfer(mbed to VS1053) optimized.
//
// 2010/10/16
// Patch loading is supported. 
// (the patch is needed to make FLAC decoder work)
// MP3,Ogg,MIDI,WMA,FLAC,AAC work correcly.
//
// 2010/10/12
// ported on mbeduino with MP3 Shield by xshige


#define mbeduino

#include "mbed.h"
#include "VS1053.h"

#ifdef mbeduino
#include "ArduinoShield.h"
#endif

/*
 
MP3 Shield Pin Assigment on mbeduino
 
Arduino MP3 Side:
RX NC
TX NC 

D2(BSYNC)
D3(DREQ)

D4(GPIO2) NC
D5(GPIO3) NC 

D9(CS)

D11(MOSI)
D12(MISO)
D13(SCK)

NC: means None-Connection so that I cut pin away. 

//-------------

 this program comming from the following code:

 Arduino MP3 Shield MP3Player
 2010/10/3
 
 This program comes from http://mbed.org/cookbook/VS1002-MP3-Decoder
 (Very small modification done to fit latest libs)
 
 
 Pin Assigenment for Arduino MP3 Shield
 (VS1053 employed, issued by sparkfun.com)
 
 MP3 Sheild Side   |  mbed Side
 ---------------------------------------
  D2(BSYNC)------------17
  D3(DREQ)-------------16

  D9(CS)---------------14

  D11(MOSI)------------11
  D12(MISO)------------12
  D13(SCK)-------------13

  GND------------------GND(1)
  5V-------------------VU(39)
  RESET----------------15

 Volume will not used. (pin20 will not used)

*/

#include "SDFileSystem.h"
SDFileSystem sd(p5, p6, p7, p8, "sd");

VS1053 mp3(
//         PinName mosi, PinName miso, PinName sck, PinName cs, PinName rst,
//         PinName dreq, PinName dcs, PinName vol)

#ifdef mbeduino
        ARD_D11,ARD_D12,ARD_D13,ARD_D9,p15,
        ARD_D3,ARD_D2,p20);
#else
        p11, p12, p13, p14, p15,
        p16, p17, p20); 
#endif


int main ()
{
// make debug port Fast
   Serial pc(USBTX, USBRX);
//  pc.baud(9600);
    pc.baud(115200);
//  pc.baud(230400);


    /*============================================================
     * MP3 Initialising
     *==========================================================*/

    mp3.initialize();
  
    /*============================================================
     * This is the good part
     *==========================================================*/

    /*====== Song Select ======*/
 for(int a=1; a<24; a++)
 {
    printf("Song#:%d\r\n",a);    
    int song_number = a;
    
//    char list[10000] = {0};
    char list[1000] = {0};
    char str[16] = {"/sd/"};
    unsigned int startplace = 0;
    unsigned int endplace = 0;
    unsigned int play = 0;
    int num_of_files = 0;

    DIR *d;
    struct dirent *p;
    d = opendir("/sd");
    if(d != NULL) 
           {
               while((p = readdir(d)) != NULL) 
           {
               strcat(list, "*");
               strcat(list, p->d_name);
               num_of_files++;
           }
    }
    else 
    {
         perror("Could not open directory!");
    }
    strcat(list, "*");                                //terminating *

    while(play != song_number)
    {
        char symbol = list[startplace];
        startplace++;
        if(symbol == 0x2A)                        //0x2A = "*"    
        {
            play++;
        }                        
    }
    play = 0;
    while(play != (song_number+1))
    {
        char symbol = list[endplace];
        endplace++;    
        if(symbol == 0x2A)                        //0x2A = "*"    
        {
            play++;
        }
    }

    strncat(str, &list[startplace], endplace-startplace);
    str[(endplace-startplace)+3] = '\0';

//printf("list: %s\r\n",list); //debug      

    /*====== File Transfer ======*/

    printf("Now Playing: %s\r\n",str);
    
    FILE *song;
//   unsigned char array[8*1024];
   unsigned char array[4*1024]; // bigger size makes click tone in AAC playing
        
    song = fopen(str, "rb");
    
    if(!song) 
    {
        exit(1);
    }
   
    while(!feof(song))
    {
        int n=fread(&array, 1, sizeof(array), song);
        mp3.writeStream(array,n);
    }
    mp3.terminateStream();

    fclose(song);  //close the file

  } // for 
    
    printf("Done.\r\n");
}
