//
// mbeduino MIDI Shield test
//
// original: SparkFun MIDI Sheild test code
//
// 2010/10/11 ported by: xshige
// I keep the original(Arduino) programming style as much as possible

#include "mbed.h"
#include "ArduinoShield.h"

// ---- --Arduino program start ------------

// SparkFun MIDI Sheild and MIDI Breakout test code
// Defines bare-bones routines for sending and receiving MIDI data
// Written 02/16/10


// defines for MIDI Shield components only
#if 1
#define KNOB1  ARD_A0
#define KNOB2  ARD_A1

#define BUTTON1  ARD_D2
#define BUTTON2  ARD_D3
#define BUTTON3  ARD_D4

#define STAT1  ARD_D7
#define STAT2  ARD_D6
#endif
#if 0
#define KNOB1  0
#define KNOB2  1

#define BUTTON1  2
#define BUTTON2  3
#define BUTTON3  4

#define STAT1  7
#define STAT2  6
#endif

#define OFF 1
#define ON 2
#define WAIT 3

byte incomingByte;
byte note;
byte velocity;
int pot;

byte byte1;
byte byte2;
byte byte3;

int action=2; //1 =note off ; 2=note on ; 3= wait

#if 1
// prototype
char button(int button_num);
// button_num should be int not char!.
void Midi_Send(byte cmd, byte data1, byte data2);

// port allocation
DigitalOut stat1(STAT1);
DigitalOut stat2(STAT2);
    
AnalogIn knob1(KNOB1);
AnalogIn knob2(KNOB2);

DigitalInOut button1(BUTTON1);
DigitalInOut button2(BUTTON2);
DigitalInOut button3(BUTTON3);

Serial midi(ARD_TX, ARD_RX);
#endif

void setup() {
#if 1
  button1.mode(PullUp);
  button2.mode(PullUp);
  button3.mode(PullUp);
#endif
#if 0
  pinMode(STAT1,OUTPUT);   
  pinMode(STAT2,OUTPUT);

  pinMode(BUTTON1,INPUT);
  pinMode(BUTTON2,INPUT);
  pinMode(BUTTON3,INPUT);

  digitalWrite(BUTTON1,HIGH);
  digitalWrite(BUTTON2,HIGH);
  digitalWrite(BUTTON3,HIGH);
#endif

  for(int i = 0;i < 10;i++) // flash MIDI Sheild LED's on startup
  {
#if 1
    stat1=HIGH;  
    stat2=LOW;
#endif
#if 0
    digitalWrite(STAT1,HIGH);  
    digitalWrite(STAT2,LOW);
#endif
    delay(30);
#if 1
   stat1=LOW;  
   stat2=HIGH;
#endif
#if 0
    digitalWrite(STAT1,LOW);  
    digitalWrite(STAT2,HIGH);
#endif
    delay(30);
  }
#if 1
  stat1=HIGH;   
  stat2=HIGH;
#endif  
#if 0
  digitalWrite(STAT1,HIGH);   
  digitalWrite(STAT2,HIGH);
#endif

  //start serial with midi baudrate 31250
#if 1
  midi.baud(31250);
#endif
#if 0
  Serial.begin(31250);     
#endif
}

void loop () {

  //*************** MIDI OUT ***************//
#if 1
  pot = knob1.read_u16();
//printf("pot:%d ",pot);// debug
#endif
#if 0
  pot = analogRead(0);
#endif
#if 1
  note = pot/511;  // convert value to value 0-127
#endif
#if 0
  note = pot/8;  // convert value to value 0-127
#endif
  if(button(BUTTON1) || button(BUTTON2) || button(BUTTON3))
  {  
    Midi_Send(0x90,note,0x45);
    while(button(BUTTON1) || button(BUTTON2) || button(BUTTON3));
  }

  //*************** MIDI LOOPBACK ******************//
#if 1
  if(midi.readable() > 0)
#endif
#if 0
  if(Serial.available() > 0)
#endif
  {
#if 1
    byte1 = midi.getc();
    byte2 = midi.getc();
    byte3 = midi.getc();
#endif
#if 0
    byte1 = Serial.read();
    byte2 = Serial.read();
    byte3 = Serial.read();
#endif
    Midi_Send(byte1, byte2, byte3);
  }

  //*************** MIDI IN ***************//
#if 1
  if (midi.readable() > 0) {
    // read the incoming byte:
    incomingByte = midi.getc();
printf("Incoming MIDI data: %02X\r\n",incomingByte);//debug
#endif
#if 0
  if (Serial.available() > 0) {
    // read the incoming byte:
    incomingByte = Serial.read();
#endif
    // wait for as status-byte, channel 1, note on or off
    if (incomingByte== 144) // Note on
    { 
      action = OFF;
    }
    else if (incomingByte== 128) // Note off
    { 
      action = ON;
    }
    else if (note==0 && action != WAIT) // note on, wait for note value
    { 
      note=incomingByte;
    }
    else if (note!=0 && action != WAIT)  // velocity
    { 
      velocity=incomingByte;
      if(action == ON){ 
        Midi_Send(0x90,note,velocity); 
      }
      if(action == OFF){ 
        Midi_Send(0x80,note,velocity); 
      }
      note=0;
      velocity=0;
      action=WAIT;
    }
    else{
    }
  }

}

void Midi_Send(byte cmd, byte data1, byte data2) {
#if 1
printf("Outgoing MIDI data: %02X:%02X:%02X\r\n",cmd,data1,data2); // debug
  midi.putc(cmd);
  midi.putc(data1);
  midi.putc(data2);
#endif
#if 0
  Serial.print(cmd, BYTE);
  Serial.print(data1, BYTE);
  Serial.print(data2, BYTE);
#endif
}

void blink(){
#if 1
  stat1=HIGH;
#endif
#if 0
  digitalWrite(STAT1, HIGH);
#endif
  delay(100);
#if 1
  stat1=LOW;
#endif
#if 0
  digitalWrite(STAT1, LOW);
#endif
  delay(100);
}
#if 1
char button(int button_num)
#endif
#if 0
char button(char button_num)
#endif
{
#if 1
    if (BUTTON1==button_num) return (!button1.read());
    if (BUTTON2==button_num) return (!button2.read());
    if (BUTTON3==button_num) return (!button3.read());
    return 0; // never happen
#endif
#if 0
  return (!(digitalRead(button_num)));
#endif
}


// -------- arduino hidden main ---------

void init(void) {
 // make debug port Fast
   Serial pc(USBTX, USBRX);
//    pc.baud(9600);
    pc.baud(115200);
//  pc.baud(230400);
    printf("mbeduino MIDI Shield Test\r\n");
    printf("Rotate Knob#1 to change note.\r\n"
            "Push any button to send MIDI note data.\r\n");
}

int main(void)
{
    init();
 
    setup();
 
    for (;;)
        loop();
 
    return 0;
}
