// lpclcd LCD test program
// 2013/11/3

#include "mbed.h"
#include "I2cLCD.h"
#include "USBSerial.h"
 
//Virtual serial port over USB
USBSerial serial;
// I2C LCD pin assignment
I2cLCD lcd(p28, p27, p29); //sda scl reset

DigitalOut myled(P1_6);
DigitalOut backlight(P1_3);
DigitalIn usersw(P0_1);

long cn;

int main() {

   backlight = 0;
   lcd.cls();
   lcd.printf("mbed lpclcd test");
   lcd.locate(0,1);
   lcd.printf("LPC11U24");

    cn = 0;
    while(1) {
        if (usersw == 1) {
           lcd.locate(0,1);
           lcd.printf("LPC11U24 %7d",cn++);        
        } else {
           lcd.locate(0,1);
           lcd.printf("lpc11u24 %7d",cn++);
        };
        serial.printf("Virtual Serial Port: LPC11U24 %7d\r\n",cn);
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
