// lpclcd AnalogIn test program
// 2013/11/4

#include "mbed.h"
#include "I2cLCD.h"
#include "USBSerial.h"
 
//Virtual serial port over USB
USBSerial serial;
// I2C LCD pin assignment
I2cLCD lcd(p28, p27, p29); //sda scl reset

// AnalogIn note:
// val = name;
// returns 0(0V) thru 1(3.3V)(float)
// val = name.read_u16();
// returns 0(0V)～65535(0xffff, 3.3V)(12bits precision)
AnalogIn ad0(P0_11);
AnalogIn ad1(P0_12);
AnalogIn ad2(P0_13);
AnalogIn ad3(P0_14);
AnalogIn ad5(P0_16);
AnalogIn ad6(P0_22);

DigitalOut myled(P1_6);
DigitalOut backlight(P1_3);
DigitalIn usersw(P0_1);

uint8_t line[128];
long cn;

int main() {

   backlight = 0;
   lcd.cls();
   lcd.printf("lpclcd AnalogIn");
   lcd.locate(0,1);
   lcd.printf("LPC11U24");

    cn = 0;
    while(1) {
        if (usersw == 1) {
           lcd.locate(0,1);
           lcd.printf("A0:%4d A1:%4d",(int)(ad0*1023),(int)(ad1*1023));
        } else {
           lcd.locate(0,1);
           lcd.printf("A2:%4d A3:%4d",(int)(ad2*1023),(int)(ad3*1023));
        };
        serial.printf("AD0: %4d\r\n",(int)(ad0*1023));
        serial.printf("AD1: %4d\r\n",(int)(ad1*1023));
        serial.printf("AD2: %4d\r\n",(int)(ad2*1023));
        serial.printf("AD3: %4d\r\n",(int)(ad3*1023));
        serial.printf("AD5: %4d\r\n",(int)(ad5*1023));
        serial.printf("AD6: %4d\r\n",(int)(ad6*1023));
        serial.printf("----------------\r\n");
        //
        wait(0.2);
        myled = (cn&1);
        cn++;
    }
}
