
//
// Thermo Sensor(TMP102 & LM61BIZ) test code
//
// ported code from Arduino
// you can see the difference between mbed and Arduino in the code.

// 2010/10/30
// written by:xshige

/*

mbed Case:
 Wiring Info for TMP102
 module side | mbed side
 GND --------- GND
 SCL --------- p10
 SDA --------- p9
 V+  --------- +3.3V
 ALT --------- NC
 ADD0 -------- GND

 Wring Info ofr LM61BIZ
 sensor side | mbed side
 +Vs --------- +5V or +3.3V
 Vout--------- p20 (analog input)
 GND --------- GND

//--------------------------------

Arduino Case:
 Wiring Info for TMP102
 module side | Arduino side
 GND --------- GND
 SCL --------- A5
 SDA --------- A4
 V+  --------- +3.3V
 ALT --------- NC
 ADD0 -------- GND

 Wring Info ofr LM61BIZ
 sensor side | Arduino side
 +Vs --------- +5V or +3.3V
 Vout--------- A3 (analog input)
 GND --------- GND

Datasheet:
http://www.sparkfun.com/datasheets/Sensors/Temperature/tmp102.pdf
http://www.national.com/ds/LM/LM61.pdf

*/

#define MBED

#ifdef MBED
#include "mbed.h"
#else
#include <Wire.h>
#endif

#ifdef MBED
I2C i2c(p9, p10);        // sda, scl
Serial pc(USBTX, USBRX); // tx, rx
char cmd[2]; // command for I2C
#endif

// setup for TMP102
#ifdef MBED
#define TEMP_REG 0x0
int tmp102 = 0x90; // with ADD0 tied to ground
// important note: (Arduino_Address<<4)==(mbed_Address)
#else
#define TEMP_REG 0b00000000
int tmp102 = 0b1001000;  // with ADD0 tied to ground
#endif

// setup for LM61BIZ
#ifdef MBED
AnalogIn LM61pin(p20); // select analog input
#else
int LM61Pin = 3;    // select analog input
#endif

void setPR(int reg) {
#ifndef MBED // not MBED
  Wire.beginTransmission(tmp102);
  Wire.send(reg);
  Wire.endTransmission();
#endif
}

int getReg() {
  unsigned char lo, hi;
#ifdef MBED
    cmd[0] = TEMP_REG; i2c.write(tmp102, cmd, 1); // set temp?reg
    i2c.read(tmp102, cmd, 2); // read the two-byte echo result
    hi = cmd[0]; lo = cmd[1];
#else
  Wire.requestFrom(tmp102, 2);
  hi = Wire.receive();
  lo = Wire.receive();
#endif
  return (hi << 8) + lo;
}

void setup()   {
#ifndef MBED // not MBED
  Serial.begin(9600);    
  Wire.begin();
  setPR(TEMP_REG);
#endif
}

void show_TMP102_temp() {
  int temp_reg = getReg();
  temp_reg >>= 4;

  float temp_C = temp_reg * 0.0625;
  float temp_F = (temp_C * 9 / 5) + 32;

#ifdef MBED
  printf("TMP102: %2.1f degree C\r\n",temp_C);
  printf("TMP102: %2.1f degree F\r\n",temp_F);
#else
  Serial.print("TMP102: ");
  Serial.print(temp_C);
  Serial.println(" degree C  ");
  Serial.print(temp_F);
  Serial.println("\xdf""F  ");
#endif
}

void show_LM61_temp() {
   // read the value from the sensor:
#ifdef MBED
  float value = 3.3*LM61pin.read_u16()/0xFFFF;  
  // in mbed, input range is 0 thru 3.3V
#else   
  float value = 5.0*analogRead(LM61Pin)/1023.0; 
  // in Arduino, input range is 0 thru 5V in many case 
#endif

  // get degree C form LM61BIZ value
  float LM61degree=(value-0.6)/0.01;

#ifdef MBED
  printf("LM61:   %2.1f degree C\r\n",LM61degree);
#else
  Serial.print("LM61:   ");
  Serial.print(LM61degree);
  Serial.println(" degree C");
#endif
}

void loop() {
  show_TMP102_temp();
  show_LM61_temp();
#ifdef MBED
  printf("\r\n"); 
#endif
}

#ifdef MBED
void init()
{
  // make debug port Fast
//    pc.baud(9600);
    pc.baud(115200);
//  pc.baud(230400);
}

int main(void)
{
    init();
 
    setup();
 
    for (;;)
        loop();
 
    return 0;
}
#endif