// sample code for ToraGi I2C board(2014/2)
// please select LPC800-MAX on mbed compiler
// Note: CPU on this board is LPC810 (NOT LPC812)
#include "mbed.h"

DigitalOut myled(P0_1); 

// generated by Switch Matrix Tool LPC810M021FN8
//----------------------------
// pin assigment
//----------------------------
// Pin Function
// 1------   RESET
// 2(P0_4)   I2C0_SCL
// 3------   SWCLK
// 4------   SWDIO
// 5(P0_1)   PIO0_1
// 6------   VDD
// 7------   VSS
// 8(P0_0)   I2C0_SDA
//----------------------------
void SwitchMatrix_Init() 
{ 
    /* Enable SWM clock */
    LPC_SYSCON->SYSAHBCLKCTRL |= (1<<7);

    /* Pin Assign 8 bit Configuration */
    /* I2C0_SDA */
    LPC_SWM->PINASSIGN7 = 0x00ffffffUL; 
    /* I2C0_SCL */
    LPC_SWM->PINASSIGN8 = 0xffffff04UL; 

    /* Pin Assign 1 bit Configuration */
    /* SWCLK */
    /* SWDIO */
    /* RESET */
    LPC_SWM->PINENABLE0 = 0xffffffb3UL; 
}

int main() {
    SwitchMatrix_Init();

    while(1) {
        myled = 1;
        wait_ms(50);
        myled = 0;
        wait_ms(50);
    }
}
