/*
    Sparkfun CC3000 WiFi Shield meets mbed!
       
    This program supports the following mbed boards with Sparkfun CC3000 Sheild.
    '#define' switches board.(refer to source code)
    (1)FRDM-KL25Z (KL25Z)
    (2)ST Nucleo F401RE (STM32F401)
    (3)ST Nucleo F030R8 (STM32F030)
    (4)LPCXpresso1549 (LPC1549)
    (5)Seeduino-Arch-Pro (ARCH_PRO)

  reference:  
    https://www.sparkfun.com/products/12071 for CC300 Shield

  date: 2014/8/31
  modified by: xshige
  
  #you get sucess when you see the following on the console.
  cc3000 Hello World demo.
  IP address: 192.168.0.2

  cc3000 connected to the Internet. Demo completed.
  
*/
/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "mbed.h"
#include "cc3000.h"

// define board you like (KL25Z, LPC1549, STM32F401, STM32F030 ...)
//#define KL25Z
#define STM32F401
//#define STM32F030
//#define LPC1549
//#define ARCH_PRO

// define SSID, PASSWORD you like
#define SSID "ssid"
#define PASSWORD "password"

using namespace mbed_cc3000;

/* cc3000 module declaration specific for user's board. */
#if defined(KL25Z)
// for KL25Z
cc3000 wifi(PTD4, PTC9, PTD0, SPI(PTD2, PTD3, PTD1), SSID, PASSWORD, WPA2, false);
Serial pc(USBTX, USBRX);
#endif
#if defined(STM32F401)
// for Nucleo STM32F401
cc3000 wifi(PA_10, PA_8, PB_6, SPI(PA_7, PA_6, PA_5), SSID, PASSWORD, WPA2, false);
// for Nucleo STM32F401
Serial pc(SERIAL_TX, SERIAL_RX);
#endif
#if defined(STM32F030)
// for Nucleo STM32F030
cc3000 wifi(PA_10, PA_8, PB_6, SPI(PA_7, PA_6, PA_5), SSID, PASSWORD, WPA2, false);
// for Nucleo STM32F030
Serial pc(SERIAL_TX, SERIAL_RX);
#endif
#if defined(LPC1549)
// for LPC1549
cc3000 wifi(P0_29, P0_0, P0_27, SPI(P0_28, P0_12, P0_16), SSID, PASSWORD, WPA2, false);
Serial pc(USBTX, USBRX);
#endif
#if defined(ARCH_PRO)
// for Seeed Studio Arch Pro
cc3000 wifi(P0_4, P2_5, P0_6, SPI(P0_9, P0_8, P0_7), SSID, PASSWORD, WPA2, false);
Serial pc(USBTX, USBRX);
#endif


/**
 *  \brief Hello World
 *  \param none
 *  \return int
 */
int main() {
    pc.baud(115200);

    printf("cc3000 Hello World demo. \r\n");
    wifi.init();
    if (wifi.connect() == -1) {
        printf("Failed to connect. Please verify connection details and try again. \r\n");
    } else {
        printf("IP address: %s \r\n",wifi.getIPAddress());
        printf("\r\ncc3000 connected to the Internet. Demo completed. \r\n");
    }

    wifi.disconnect();
}

