/*
    CC3000 OSC message tranceiver(Sender/Receiver)

    Sparkfun CC3000 WiFi Shield meets mbed!
       
    This program supports the following mbed boards with Sparkfun CC3000 Sheild.
    '#define' switches board.(refer to source code)
    (1)FRDM-KL25Z (K25Z)
    (2)ST Nucleo F401RE (STM32F401)
    (3)ST Nucleo F030R8 (STM32F030)
    (4)LPCXpresso1549 (LPC1549)
    (5)Seeduino-Arch-Pro (ARCH_PRO)
    (6)FRDM-K64F (K64F)
    
 Please push RESET button on CC3000 WiFi Shield to start the program.

  reference:  
    https://www.sparkfun.com/products/12071 for CC300 Shield
    http://opensoundcontrol.org/introduction-osc for OSC(Open Sound Control)

  date: 2014/9/3
  added supporting FRDM-K64F by: xshige

  date: 2014/8/31
  written by: xshige

console out sample:
==========================================
CC3000 OSC receive&send demo.
IP address: 192.168.0.3
This OSC msg sent:
/1/fader1 ,f 0.000000
to: 192.168.0.11
-------------------
This OSC msg sent:
/1/fader5 ,f 0.172000
to: 192.168.0.11
-------------------

Wait for OSC message...

This OSC msg sent:
/1/fader5 ,f 0.127000
to: 192.168.0.11
-------------------

Wait for OSC message...

incomming OSC msg:
/1/fader2 ,f 0.761603
Received packet from: 192.168.0.2
-------------------
This OSC msg sent:
/1/fader5 ,f 0.711000
to: 192.168.0.2
-------------------

Wait for OSC message...

incomming OSC msg:
/1/fader2 ,f 0.767932
Received packet from: 192.168.0.2
-------------------
This OSC msg sent:
/1/fader5 ,f 0.286000
to: 192.168.0.2
-------------------

Wait for OSC message...

==========================================
*/

#include "mbed.h"
#include "cc3000.h"

#include "UDPSocket.h"

// define board you like (KL25Z, LPC1549, STM32F401, STM32F030 ...)
//#define KL25Z
//#define STM32F401
//#define STM32F030
//#define LPC1549
//#define ARCH_PRO
#define K64F

// define SSID, PASSWORD you like
#define SSID "sssid"
#define PASSWORD "password"

using namespace mbed_cc3000;

/* cc3000 module declaration specific for user's board. */
#if defined(KL25Z)
// for KL25Z
cc3000 wifi(PTD4, PTC9, PTD0, SPI(PTD2, PTD3, PTD1), SSID, PASSWORD, WPA2, false);
Serial pc(USBTX, USBRX);
#endif
#if defined(STM32F401)
// for Nucleo STM32F401
cc3000 wifi(PA_10, PA_8, PB_6, SPI(PA_7, PA_6, PA_5), SSID, PASSWORD, WPA2, false);
// for Nucleo STM32F401
Serial pc(SERIAL_TX, SERIAL_RX);
#endif
#if defined(STM32F030)
// for Nucleo STM32F030
cc3000 wifi(PA_10, PA_8, PB_6, SPI(PA_7, PA_6, PA_5), SSID, PASSWORD, WPA2, false);
// for Nucleo STM32F030
Serial pc(SERIAL_TX, SERIAL_RX);
#endif
#if defined(LPC1549)
// for LPC1549
cc3000 wifi(P0_29, P0_0, P0_27, SPI(P0_28, P0_12, P0_16), SSID, PASSWORD, WPA2, false);
Serial pc(USBTX, USBRX);
#endif
#if defined(ARCH_PRO)
// for Seeed Studio Arch Pro
cc3000 wifi(P0_4, P2_5, P0_6, SPI(P0_9, P0_8, P0_7), SSID, PASSWORD, WPA2, false);
Serial pc(USBTX, USBRX);
#endif
#if defined(K64F)
// for FRDM-K64F
cc3000 wifi(PTB9, PTC3, PTD0, SPI(PTD2, PTD3, PTD1), SSID, PASSWORD, WPA2, false);
Serial pc(USBTX, USBRX);
#endif


// OSC related
#include "OSCmsgCodec.h"

// set yout IP, PORTs
#define REMOTE_IP "192.168.0.11" // (will be replaced after OSC msg received)
#define OUTGOING_PORT 9000
#define INCOMMING_PORT 8000
    
#define PACKET_SIZE 512
#define RECBUF_SIZE 256
#define PERIOD_BUZZER 10

union OSCarg msg[10], outmsg[10];
char recbuf[RECBUF_SIZE],buff[PACKET_SIZE],packet[PACKET_SIZE];
int len, tn;

char sendto_ip[16];

int main() {    
    // set initial IP to send
    strcpy(sendto_ip, REMOTE_IP);

    pc.baud(115200);

    printf("\n\nCC3000 OSC receive&send demo. \n");
    wifi.init();
    if (wifi.connect() == -1) {
        printf("Failed to connect. Please verify connection details and try again. \n");
        printf("You should check your ssid, password.\n");        
        wait(60);
    } else {
        printf("IP address: %s \n", wifi.getIPAddress());
    }
    
    UDPSocket udpRec,udpSend;
    udpSend.init(); udpRec.bind(INCOMMING_PORT);

    Endpoint target, client;
    target.set_address(REMOTE_IP, OUTGOING_PORT);
        
    // send OSC message with random values (to touchOSC)
    // make OSC message for sending
    outmsg[0].address="/1/fader1";    
    outmsg[1].typeTag=",f";
    outmsg[2].f= 0.0;
    memset(packet,0,sizeof(packet)); // clear send buff for OSC msg
    len=encOSCmsg(packet,outmsg);
    // send it
    target.set_address(sendto_ip, OUTGOING_PORT);    
    udpSend.sendTo(target, packet, len);
    pc.printf("This OSC msg sent:\n%s %s %f\n", outmsg[0].address, outmsg[1].typeTag, outmsg[2].f);
    pc.printf("to: %s\n", sendto_ip);
    pc.printf("-------------------\n");
    //wait_ms(10);
 
    while (true) {
#if 0
        // xy 
        // send OSC message with random values  (to touchOSC)
        // make OSC message for sending
        outmsg[0].address="/3/xy";    
        outmsg[1].typeTag=",ff";
        outmsg[2].f = rand()%1000/1000.0;
        outmsg[3].f = rand()%1000/1000.0;
        memset(packet,0,sizeof(packet)); // clear send buff for OSC msg
        len=encOSCmsg(packet,outmsg);
        target.set_address(sendto_ip, OUTGOING_PORT);    
        udpSend.sendTo(target, packet, len);        
//pc.printf("len:%d\n",len);
        pc.printf("This OSC msg sent:\n%s %s %f %f\n", outmsg[0].address, outmsg[1].typeTag, outmsg[2].f, outmsg[3].f);
        pc.printf("to: %s\n", sendto_ip);
        pc.printf("-------------------\n");
        //wait_ms(10);
#else
        // fader
        // send OSC message with random values (to touchOSC)
        // make OSC message for sending
        outmsg[0].address="/1/fader5";    
        outmsg[1].typeTag=",f";
        outmsg[2].f= rand()%1000/1000.0;
        memset(packet,0,sizeof(packet)); // clear send buff for OSC msg
        len=encOSCmsg(packet,outmsg);
        // send it
        target.set_address(sendto_ip, OUTGOING_PORT);    
        udpSend.sendTo(target, packet, len);
//pc.printf("len:%d\n",len);
        pc.printf("This OSC msg sent:\n%s %s %f\n", outmsg[0].address, outmsg[1].typeTag, outmsg[2].f);
        pc.printf("to: %s\n", sendto_ip);
        pc.printf("-------------------\n");
        //wait_ms(10);
#endif

        // receive OSC message        
        printf("\nWait for OSC message...\n\n");
        int n = udpRec.receiveFrom(client, recbuf, sizeof(recbuf));
        if (n >= 0) {
            decOSCmsg(recbuf, msg);
            pc.printf("incomming OSC msg:\n%s %s", msg[0].address, msg[1].typeTag);
            for(int m=0; m < (strlen(msg[1].typeTag)-1); m++) {
                if (msg[1].typeTag[m+1]=='f') pc.printf(" %f",msg[m+2].f);
                if (msg[1].typeTag[m+1]=='i') pc.printf(" %d",msg[m+2].i);                
            }
            pc.printf("\n");
            printf("Received packet from: %s \n", client.get_address());
            printf("-------------------\n");
            // change IP to send
            strcpy(sendto_ip, client.get_address());
            //wait_ms(10);
        };
    } // while (true)
}
