// 
// OSC Receiver
//
// date: 2011/1/10
// version: 0.7
// written by: xshige
//
// please find OSC Sender program at the bottom of this file
//
/*
  The followings are supported:

    Transport Type: 
      UDP

    Features: 
     Packet Parsing (Client)
     Not Supported:Packet Construction (Server)
     Bundle NOT Support
     Timetag NOT Support

    Type Support: 
     i: int32
     b: blob
     s: string
     f: float32
     m: MIDI message(port id, status byte, data1, data2) // I don't know the detail
 
*/


#include "mbed.h"
#include "EthernetNetIf.h"
#include "UDPSocket.h"

//#define DHCP

//#define INPUT_PORT 12000
#define INPUT_PORT 57130

#ifdef DHCP
EthernetNetIf eth;
#else
EthernetNetIf eth(
  IpAddr(192,168,0,25), //IP Address
  IpAddr(255,255,255,0), //Network Mask
  IpAddr(192,168,0,1), //Gateway
  IpAddr(192,168,0,1)  //DNS
);
#endif

//--- OSC related stuff ---
union OSCarg {
// char*, int and float are assumed four bytes
        char *address;
        char *typeTag;
        int i;
        float f;
        char *s;
        struct {
            int len; // is "int i"
            char *p;
        } blob;
        char m[4];  // for MIDI
        char _b[4]; // endian conversion temp variable
};

void getOSCmsg(char *packet , union OSCarg *msg){
// Caution: the returned result points to packet as blobs or strings (not newly allocatd)
    char *p, *typeTag; char c;
        
    msg[0].address = packet; // address
    msg[1].typeTag = packet+4*(strlen(msg[0].s)/4+1);//typeTag
    typeTag=msg[1].s+1; // skip ','
    p= msg[1].s+4*(strlen(msg[1].s)/4+1);
    for(int n=0; n<strlen(typeTag); n++){
        c = typeTag[n];
        if (('s'==c)) {
            msg[n+2].s=p;
            p += 4*(strlen(msg[n+2].s)/4+1);
        } else if (('i'==c)||('f'==c)) {
            // chang endian (big to little)
            msg[n+2]._b[3]=p[0]; 
            msg[n+2]._b[2]=p[1]; 
            msg[n+2]._b[1]=p[2];
            msg[n+2]._b[0]=p[3];
            p +=4;  
        } else if ('b'==c) {
            // chang endian (big to little)
            // get lenth of blog (copy to msg[n].blog.len)
            msg[n+2]._b[3]=p[0]; 
            msg[n+2]._b[2]=p[1]; 
            msg[n+2]._b[1]=p[2];
            msg[n+2]._b[0]=p[3];
            p +=4;  
            // get ponter of blog (copy to msg[n].blog.p)
            msg[n+2].blob.p=p;
            p += 4*(msg[n+2].blob.len/4+1);       
        } else if ('m'==c) {
            // get midi data (copy to msg[n].m[])
            msg[n+2].m[0]=p[0]; 
            msg[n+2].m[1]=p[1]; 
            msg[n+2].m[2]=p[2];
            msg[n+2].m[3]=p[3];
            p +=4;  
        } else {
            printf("*** Not Supported TypeTag:%s ****\n",typeTag);
        }
    };
    
}
//-------------------------------------------

UDPSocket udp;


void onUDPSocketEvent(UDPSocketEvent e)
{
  union OSCarg msg[10];

  switch(e)
  {
  case UDPSOCKET_READABLE: //The only event for now
    char buf[256] = {0};
    Host host;
    while( int len = udp.recvfrom( buf, 256, &host ) )
    {
      if( len <= 0 )
        break;
      printf("\r\nFrom %d.%d.%d.%d:\r\n", 
      host.getIp()[0], host.getIp()[1], host.getIp()[2], host.getIp()[3]);
      
      getOSCmsg(buf,msg);
      // address pattern samples
      if (strcmp(msg[0].address,"/test")==0) {
        printf("OSCmsg: %s %s %d %f %s %d\n", 
            msg[0].address, msg[1].typeTag,msg[2].i, msg[3].f, msg[4].s, msg[5].blob.len);
        printf("blob content:\n");
        char *p=msg[5].blob.p;
        for(int n=0; n<msg[5].blob.len; p++,n++) printf(" %02X",(unsigned char)(*p));
        printf("\n");
        break;
      }
      if (strcmp(msg[0].address,"/kb/m")==0) {
        printf("OSCmsg: %s %s %d %d %d\n", 
            msg[0].address, msg[1].typeTag,msg[2].i, msg[3].i, msg[4].i);
        break;
      }
      if (strcmp(msg[0].address,"/cc/m")==0) {
        printf("OSCmsg: %s %s %d %d %d\n", 
            msg[0].address, msg[1].typeTag,msg[2].i, msg[3].i, msg[4].i);
        break;
      }
      if (strcmp(msg[0].address,"/1/fader1")==0) {
        printf("OSCmsg: %s %s %f\n", 
            msg[0].address, msg[1].typeTag,msg[2].f);
        break;
      }
      if (strcmp(msg[0].address,"/1/knob1")==0) {
        printf("OSCmsg: %s %s %f\n", 
            msg[0].address, msg[1].typeTag, msg[2].f);
        break;
      } 
      if (strcmp(msg[0].address,"/1/butt/A1")==0) {
        printf("OSCmsg: %s %s %i\n", 
            msg[0].address, msg[1].typeTag, msg[2].i);
        break;
      }
      if (strcmp(msg[0].address,"/1/butt/B1")==0) {
        printf("OSCmsg: %s %s %i\n", 
            msg[0].address, msg[1].typeTag, msg[2].i);
        break;
      }
      if (strcmp(msg[0].address,"/mouse/dragged")==0) {
        printf("OSCmsg: %s %s %i %i\n", 
            msg[0].address, msg[1].typeTag, msg[2].i, msg[3].i);
        break;
      }
      if (strcmp(msg[0].address,"/mouse/pressed")==0) {
        printf("OSCmsg: %s %s %i %i\n", 
            msg[0].address, msg[1].typeTag, msg[2].i, msg[3].i);
        break;
      }
      if (strcmp(msg[0].address,"/1/xy")==0) {
        printf("OSCmsg: %s %s %f %f %d\n", 
            msg[0].address, msg[1].typeTag, msg[2].f, msg[3].f, msg[4].i);
        break;
      }
      printf("undefined OSCmsg:%s %s\n",msg[0].address, msg[1].typeTag);
    } // while
    break;
  } // case
}

int main() {
// make debug port Fast
   Serial pc(USBTX, USBRX);
//    pc.baud(9600);
    pc.baud(115200);
//  pc.baud(230400);

  printf("Setting up...\r\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\r\n", ethErr);
    return -1;
  }
  printf("Setup OK\r\n");
  

  // port setup
  Host recHost(IpAddr(192, 168, 0, 7), INPUT_PORT, NULL);
  udp.setOnEvent(&onUDPSocketEvent);
  udp.bind(recHost);
  
  Timer tmr;
  tmr.start();
  while(true)
  {
    Net::poll();
    if(tmr.read() > 5)
    {
      tmr.reset();
    }
  }

  
}
//----------------------------------------------------------------------------------------------------------
/*

//
// OSC mouse (OSC Sender)
//
// written in: processing(refer to: http://processing.org/)
//
// please install oscP5 lib
// you can download this from: http://www.sojamo.de/libraries/oscP5/

import oscP5.*;

// initialise all OSC functionality
void initOsc() {
  host = "192.168.0.25"; // mbed IP address (change this to fit your mbed)
  sendToPort = 57130; // mbed port# (chang this if you need)
  receiveAtPort = 12000; // not used at this time 
  oscP5event = "oscEvent"; // the analyser method 
  oscP5 = new OscP5(this, host, sendToPort, receiveAtPort, oscP5event);
}

// oscP5 instance for the osc communication
OscP5 oscP5;
int receiveAtPort;
int sendToPort;
String host;
String oscP5event;

void setup(){
  background(0);
  size(400, 400);   
  initOsc();
  sendTestMsg();
}

void oscEvent(OscIn oscIn) {
  println("\n\nreceived a message ... forwarding to analyseMessage(OscIn)");
  analyseMessage(oscIn);
}

void analyseMessage(OscIn oscIn) {  
    println("you have received an osc message "+
      oscIn.getAddrPatternAsBytes()+"   "+oscIn.getTypetagAsBytes()
      );
      byte[] o = oscIn.getBytes();
     for(int i=0;i<o.length;i++) {
      if ((i%4)==0) println("\n--------------------");
      print(hex(o[i],2)+"("+char(o[i])+")"+":");
       if ((((i+1)%4)==0)&&((i+1)>=4)) {
         int data= (0x1000000*(o[i-3]&0xFF)+
               0x10000*(o[i-2]&0xFF)+
               0x100*(o[i-1]&0xFF)+
               (o[i]&0xFF));
         print("\nint: "+data);
         print("\nfloat: "+Float.intBitsToFloat(data));
    }
  }
}    

void draw() {
}

void sendTestMsg() {        
  OscMessage oscMsg= oscP5.newMsg("/test");
  oscMsg.add(mouseY);
  oscMsg.add(34.55);
  oscMsg.add("yippyy!"); 
  // add a byte blob to the osc message
  oscMsg.add(
     new byte[] {0x00, 0x01, 0x10, 0x20,0x30,0x40,0x50,0x60,0x7F,
       -128,-1,(byte)0x80,(byte)0x90,(byte)0xA0,(byte)0xB0,(byte)0xC0,
     (byte)0xD0,(byte)0xE0,(byte)0xFF});
 // 0x80,0x90,0xFE,0xFF etc do not work because byte is 127 thru -128.
 // so do it like: (byte)0xFF
  oscP5.send(oscMsg);
}

void mousePressed() {        
  OscMessage oscMsg= oscP5.newMsg("/mouse/pressed");
  oscMsg.add(mouseX);
  oscMsg.add(mouseY);
  oscP5.send(oscMsg);
//
  oscMsg= oscP5.newMsg("/1/xy");
  oscMsg.add(mouseX*1.0/width);
  oscMsg.add(mouseY*1.0/height);
  oscMsg.add(1);// button status:pressed
  oscP5.send(oscMsg);
}

void mouseDragged() { 
  OscMessage oscMsg= oscP5.newMsg("/mouse/dragged");
  oscMsg.add(mouseX);
  oscMsg.add(mouseY);
  oscP5.send(oscMsg);
//
  oscMsg= oscP5.newMsg("/1/xy");
  oscMsg.add(mouseX*1.0/width);
  oscMsg.add(mouseY*1.0/height);
  oscMsg.add(1); // button status:pressed
  oscP5.send(oscMsg);
}

void mouseReleased() {        
  OscMessage oscMsg= oscP5.newMsg("/1/xy");
  oscMsg.add(mouseX*1.0/width);
  oscMsg.add(mouseY*1.0/height);
  oscMsg.add(0); // button status:released
  oscP5.send(oscMsg);
}
*/
//----------------------------------------------------------------------------------------------------------
