#include "mbed.h"
#include "TextLCD.h"

DigitalOut myled(LED1);

//#define ARCHPRO

#if 0
// template
    //  LCD (RS, EN, D4, D5, D6, D7)
    TextLCD lcd(D8, D9, D4, D6, D6, D7); // LCD Shield for Arduino (DFR00009)
    AnalogIn button(A0);  // board button
    PwmOut backlight(D10);
#endif
#ifdef ARCHPRO
    //  LCD (RS, E, D4, D5, D6, D7)
    TextLCD lcd(P0_0, P0_1, P2_2, P2_3, P2_4, P2_5); // LCD Shield for Arduino (DFR00009)
    AnalogIn button(P0_23);  // board button
    //PwmOut backlight(P0_6);
    DigitalOut backlight(P0_6);    
#endif
#ifdef TARGET_K64F
// *** IMPORTANT NOTE ***
// to make it work correctly, you should supply directly(Not via PC USB) power to *K64F_USB* connecter.
// **********************
    //  LCD (RS, E, D4, D5, D6, D7)
    TextLCD lcd( PTA0, PTC4, PTB23, PTA2, PTC2, PTC3); // LCD Shield for Arduino (DFR00009)
    AnalogIn button(PTB2);  // board button
    //PwmOut backlight(PTD0);
    DigitalOut backlight(PTD0);
#endif
#ifdef STM32F401xE
    //  LCD (RS, E, D4, D5, D6, D7)
    TextLCD lcd(PA_9, PC_7, PB_5, PB_4, PB_10, PA_8); // LCD Shield for Arduino (DFR00009)
    AnalogIn button(PA_0);  // board button
    PwmOut backlight(PB_6);
#endif
#ifdef STM32F030
    //  LCD (RS, E, D4, D5, D6, D7)
    TextLCD lcd(PA_9, PC_7, PB_5, PB_4, PB_10, PA_8); // LCD Shield for Arduino (DFR00009)
    AnalogIn button(PA_0);  // board button
    PwmOut backlight(PB_6);
#endif
#ifdef TARGET_LPC1549
    //  LCD (RS, E, D4, D5, D6, D7)
    TextLCD lcd(P0_24, P1_0, P0_10, P0_16, P1_3, P0_0); // LCD Shield for Arduino (DFR00009)
    AnalogIn button(P0_8);  // board button
    PwmOut backlight(P0_27);
#endif
#ifdef TARGET_KL25Z
    //  LCD (RS, E, D4, D5, D6, D7)
    TextLCD lcd(PTA13, PTD5, PTA4, PTA5, PTC8, PTC9); // LCD Shield for Arduino (DFR00009)
    AnalogIn button(PTB0);  // board button
    PwmOut backlight(PTD0);
#endif

/***
 * ---------------------------------------------
 *   Arduino LCD KeyPad Shield (SKU: DFR0009)
 * ---------------------------------------------
 *  - Button            : a0  -> PTB0
 *                                 right  : < 0.15
 *                                 up     : < 0.35
 *                                 down   : < 0.65
 *                                 left   : < 0.99
 *                                 select : ???
 * ---------------------------------------------
 *  - DB4               : d4  -> pta4
 *  - DB5               : d5  -> pta5
 *  - DB6               : d6  -> ptc8
 *  - DB7               : d7  -> ptc9
 *  - RS                : d8  -> pta13
 *  - Enable            : d9  -> ptd5
 *  - Backlight Control : d10 -> ptd0
 * ---------------------------------------------
 *  - http://www.dfrobot.com/wiki/index.php/Arduino_LCD_KeyPad_Shield_(SKU:_DFR0009)
 *  - http://www.dfrobot.com/index.php?route=product/product&keyword=DFR0009&category_id=0&description=1&model=1&product_id=51
 *  - http://www.amazon.co.jp/dp/B00ACCN148
 *  - http://akizukidenshi.com/catalog/g/gM-07029/
***/

int main()
{
    int count = 0;
//#ifdef TARGET_KL25Z
    backlight = 1;  // ON: 1, OFF: 0
    lcd.cls();
    lcd.printf("HELLO");
    wait(0.5);
//#endif
    while (1)
    {
        myled = (myled == 1) ? 0 : 1;
        count = count + 1;

//#ifdef TARGET_KL25Z
        // READ BUTTON VALUE
        unsigned long value = button.read_u16();

        // LCD OUTPUT
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("%d", count);    // loop counter

        lcd.locate(0,1);
        lcd.printf("BUTTON : %04x", value);  // button value
        //lcd.printf("BUTTON : %02x", value>>8);  // button value
//#endif
        wait(0.2);
    }
}
