
#include "mbed.h"
#include "VS1002.h"

/*

 Arduino MP3 Shield MP3Player
 2010/10/3
 
 This program comes from http://mbed.org/cookbook/VS1002-MP3-Decoder
 (Very small modification done to fit latest libs)
 
 
 Pin Assigenment for Arduino MP3 Shield
 (VS1053 employed, issued by sparkfun.com)
 
 MP3 Sheild Side   |  mbed Side
 ---------------------------------------
  D2(BSYNC)------------17
  D3(DREQ)-------------16

  D9(CS)---------------14

  D11(MOSI)------------11
  D12(MISO)------------12
  D13(SCK)-------------13

  GND------------------GND(1)
  5V-------------------VU(39)
  RESET----------------15

 Volume will not used. (pin20 will not used)

*/


//PinName mmosi, PinName mmiso, PinName ssck, PinName ccs, const char *name,
//         PinName mosi, PinName miso, PinName sck, PinName cs, PinName rst,
//         PinName dreq, PinName dcs, PinName vol)
VS1002 mp3(p5, p6, p7, p8, "sd",
        p11, p12, p13, p14, p15,
        p16, p17, p20);     //p14 in BoB non-functional so replace with p18


int main ()
{
  // make debug port Fast
   Serial pc(USBTX, USBRX);
//    pc.baud(9600);
    pc.baud(115200);
//  pc.baud(230400);

    /*============================================================
     * MP3 Initialising
     *==========================================================*/
#ifndef FS_ONLY    
    mp3._RST = 1;
    mp3.cs_high();                                   //chip disabled
    mp3.sci_initialise();                            //initialise MBED
    mp3.sci_write(0x00,(SM_SDINEW+SM_STREAM+SM_DIFF));
    mp3.sci_write(0x03, 0x9800);
    mp3.sdi_initialise();    
#endif        
    /*============================================================
     * This is the good part
     *==========================================================*/

    for(int a=1; a<24; a++)
    {
        printf("Song#:%d\r\n",a); 
        mp3.play_song(a);
        wait(1);
    }
    printf("Done.\r\n");
}
