
// pour lecture I2C  accelerometre 
   PinName const SDA = PTE25;
   PinName const SCL = PTE24; 
   I2C i2c(SDA,SCL);

#define REG_WHO_AM_I      0x0D
#define REG_CTRL_REG_1    0x2A
#define REG_OUT_X_MSB     0x01
#define REG_OUT_Y_MSB     0x03
#define REG_OUT_Z_MSB     0x05

#define MMA8451_I2C_ADDRESS (0x1d<<1)

// #define UINT14_MAX        16383
#define UINT14_MAX        16384


static const float redx=0.0f;
static const float redy=1.0f;
static const float greenx=sqrt(3.0f)/2.0f;
static const float greeny=-0.5f;
static const float bluex=-sqrt(3.0f)/2.0f;
static const float bluey=-0.5f;

static const float twothirds=2.0f/3.0f;


float acclnread(uint8_t reg)
{
  // Normalisation here seems wrong
  char t[1]= {reg};
  i2c.write(MMA8451_I2C_ADDRESS,t,1,true);
  uint8_t xbits[2] = {0,0};
  i2c.read(MMA8451_I2C_ADDRESS,(char *)xbits,2);
  int16_t xint = 0;
  xint=(xbits[0]<<6)|(xbits[1]>>2);
  // this sign flip code looks wrong, UINT14_MAX maps to 0
  // UINT14_MAX=16383, should it be UINT14_MAX=16384 
  if (xint > UINT14_MAX>>1)
    xint -= UINT14_MAX;
  return float(xint)/4096.0f;
  //  return float(xint);
}
