/* #####################################################################
                                Tasks.h
                                -------
                
                     Embedded Software - Assignment 2
                     --------------------------------
 
 Written by:        Xavier Gouesnard
 
 Date:              March 2017
 
 Function:          This file contains the function prototypes for the
                    included classes and methods. It also details some
                    constants used within the program and includes AUX
                    files, for instance the LCD system and the SD card.

 ##################################################################### */

#ifndef _TASKS_H_
#define _TASKS_H_

// Includes to operate the LCD Display
#include "MCP23017.h"
#include "WattBob_TextLCD.h"

// Includes to operate the SD Card system
#include "SDFileSystem.h"

// Global definitions
#define HIGH 1
#define LOW 0
#define TRUE 1
#define FALSE 0

// Task 1 definitions
#define SAMPLE_FREQ 1
    
// Task 2 definitions

// Task 3 definitions
#define WATCHDOG_PULSE_WIDTH 15 // ms

// Task 4 definitions
#define NUM_ANALOG_SAMPLES 4.0
#define V_SUPPLY 3.3

// Task 5 definitions
#define BACK_LIGHT_ON(INTERFACE) INTERFACE->write_bit(1,BL_BIT)
#define BACK_LIGHT_OFF(INTERFACE) INTERFACE->write_bit(0,BL_BIT)

// Task 6 definitions
#define ERROR_CODE_CDTN_MET 3
#define ERROR_CODE_CDTN_FAIL 0


/* ####################### Class definitions and prototypes ####################### */

/* ==================================== Task 1 ==================================== */
// Measure freuqnecy
class Task1
{
public:
    // Public constructer method
    Task1(PinName squareWaveInPin);
    
    // Public method which initiates and returns a frequency measurement
    int ReadFrequency();
        
private:
    // Private Timer object used to count the high or low time of input signal
    Timer _Task1Timer;
    
    // Private method which contains the logic to measure frequency
    void MeasureFrequency();
    
    // Private and volatile field contains most recent frequency
    // Volatile to avoid the compiler modifying it for any reason
    volatile int measuredFrequency;

protected:
    // Pointer to DigitalIn object
    DigitalIn *_squareWaveIn;
};

 
/* ==================================== Task 2 ==================================== */ 
// Digital Input
class Task2
{
public:
    // Public constructer method
    Task2(PinName digitalInCheckPin);
    
    // Public method to return the state of the DigitalIn pin
    bool digitalInState();
    
private:

    
protected:
    // Pointer to DigitalIn Object
    DigitalIn *_digitalInCheck;
};


/* ==================================== Task 3 ==================================== */ 
// Output watchdog pulse
class Task3
{
public:
    // Public constructer method
    Task3(PinName WatchdogPin);
    
    // Public method to output watchdog pulse opon calling method
    void OutputWatchdogPulse();
        
private:


protected:
    // Pointer to DigitalOut Object
    DigitalOut *_Watchdog;
};


/* ==================================== Task 4 ==================================== */ 
// Read 2 analog inputs 
class Task4
{
public:
    // Public constructer method
    Task4(PinName Analog1Pin,PinName Analog2Pin);
    
    // Public method to return pointer to array containing 
    // the filtered analog results, increment pointer once for both results
    float *returnAnalogReadings();
    
private:


protected:
    // Pointers to AnalogIn channels
    AnalogIn *_AnalogIn1;
    AnalogIn *_AnalogIn2;   
};

//* ==================================== Task 5 ==================================== */
// Display outputs to LCD
class Task5
{
public:
    // Public constructer method
    Task5(PinName sda, PinName scl, int address);
    
    // Public method to update display using input values from other tasks
    void updateDisplay( int task1Param,
                        int task2Param,
                        int errorState,
                        float task4Channel1,
                        float task4Channel2  );
                             
private:


protected:
    // Pointers to required LCD objects
    MCP23017 *_par_port;
    WattBob_TextLCD *_lcd; 
};

///* ==================================== Task 6 ==================================== */
// Logical checks
class Task6
{
public:
    // Public method to calculate condition of error state
    int updateErrorCode(int switch_1, float analog1, float analog2);  

private:


protected:


};

/* ==================================== Task 7 ==================================== */
// Save data to SD Card
class Task7
{
public:
    // Public constructer method
    Task7(  PinName mosi,
            PinName miso,
            PinName sck,
            PinName cs,
            const char* SDName,
            const char *dir     );
            
    // Public method to output Stream of data to open FILE
    void writeData(const char *dataStream);
    
    // Public method to open FILE
    int openFile(const char *dirFile, const char *accessType);
    
    // Public method to close FILE
    void closeFile();
    
private:
    // Private method to construct a new directory on SD
    void makeDirectory(const char *dir);

protected:
    // Pointer to SDFileSystem object
    SDFileSystem *_sd;
    
    // Pointer to FILE object
    FILE *fp;
};

#endif
