/**
 * Task that logs the state to a file on the SD card in csv format
 *
 * Author: Jacob Baungard Hansen
 */

#include "sdcard_task.h"

/**
 *
 * @param starting_offset       when the task should but run first
 * @param frequency_ms              the frequency in ms of how often the task should run
* @param state                          pointer to the state object to print
 */
SDCardTask::SDCardTask(int starting_offset, int frequency_ms,
                                                                     State * state)
                                    : Task(starting_offset, frequency_ms) {
                                        
    this->state = state;
    // mount the file system
    this->sd = new SDFileSystem(p5, p6, p7, p8, "sd");
    
    // set the folder
    this->folder = "/sd/embedded";
    
    // ensure folder exists
    struct stat s = {0};

    if (!stat(folder.c_str(), &s)) { }
    else {
      mkdir(folder.c_str(), 0777); 
    }
    
    // set file to log to
    this->file.append(folder);
    file.append("/data.csv");
    
    // clear previous data and set headers
    FILE *fp = fopen(file.c_str(), "w");
    if(fp == NULL) {
      error("Could not open file for write\n");
    }
    fprintf(fp, "frequency,digital1,digital2,analog1,analog2\n");
    fclose(fp);

}

SDCardTask::~SDCardTask() {
    delete this->sd;
}

void SDCardTask::action() {
    
    // ensure file can be opened
    FILE *fp = fopen(file.c_str(), "a");
    if(fp == NULL) {
      error("Could not open file for write\n");
    }
    // print current state
    fprintf(fp, "%d,%d,%d,%f,%f\n", this->state->get_freq(), this->state->get_digital_1(), 
                                                                this->state->get_digital_2(), this->state->get_avg_analog_1(),
                                                                this->state->get_avg_analog_2());
    fclose(fp); 
    
    
}