#include "update_analog_task.h"

/**
 *
 * @param starting_offset           when the task should but run first
 * @param frequency_ms              the frequency in ms of how often the task should run
 * @param state                             pointer to the state object
 */
UpdateAnalogTask::UpdateAnalogTask(int starting_offset, int frequency_ms,
                                                                     State * state)
                                    : Task(starting_offset, frequency_ms) {
                                        
    this->state = state;
    this->analog_in_1 = new AnalogIn(p17);
    this->analog_in_2 = new AnalogIn(p18);
}

UpdateAnalogTask::~UpdateAnalogTask() {
    delete this->analog_in_1;
    delete this->analog_in_2;
}

void UpdateAnalogTask::action() {
    this->state->update_analog(this->analog_in_1->read(), this->analog_in_2->read());
}