/**
 * Task for getting the frequency from digital input on pin13. 
 * The frequency is calculated by counting the number of rises
 * on the pin. This is done using an interupt handler.
 *
 * Author: Jacob Baungard Hansen
 */
#include "freq_task.h"

FrequencyTask::FrequencyTask(int starting_offset, int frequency_ms,
                                                                     State * state)
                                    : Task(starting_offset, frequency_ms) {
                                        
    this->state = state;
    this->count = 0;
    this->interrupt = new InterruptIn(p13); 

}

FrequencyTask::~FrequencyTask() {
    delete this->interrupt;
}

/**
 * This is called by the interupt, simply adds one to the count
 */
void FrequencyTask::counter() {
    this->count++;
}

void FrequencyTask::action() {
    // reset the count
    this->count=0;
    // Enable the iterrupt
    this->interrupt->rise<FrequencyTask>(this, &FrequencyTask::counter);
    // wait for a specied amout of time
    wait_ms(SAMPLE_LENGTH_MS);
    // disable interrupts
    this->interrupt->rise(NULL);
    //interupt.rise<FrequencyTask>(this, NULL); This crashes, should report bug to ARM
    int freq = 0;
    if (this->count > 0) {
        freq = count/(SAMPLE_LENGTH_MS*0.001);
    }
    
    this->state->set_freq(freq);
}