/**
 * This task do a binary count on the 4 mbed LEDs
 *
 * Author: Jacob Baungard Hansen
 */

#include "counting_task.h"

/**
 *
 * @param starting_offset       when the task should but run first
 * @param frequency_ms          the frequency in ms of how often the task should run
 */
CountingTask::CountingTask(int starting_offset, int frequency_ms)
                                    : Task(starting_offset, frequency_ms) {
                                        
  this->count = 0;

    this->led1 = new DigitalOut(LED1);
    this->led2 = new DigitalOut(LED2);
    this->led3 = new DigitalOut(LED3);
    this->led4 = new DigitalOut(LED4);
    

}

CountingTask::~CountingTask() {
    delete this->led1;
    delete this->led2;
    delete this->led3;
    delete this->led4;
}

/** 
 * The function that is run at the specified frequency.
 */
void CountingTask::action() {

  // simple way to get the bits
    std::bitset<4> bits(this->count);
    
    // set the result
    this->led1->write(bits[3]);
    this->led2->write(bits[2]);
    this->led3->write(bits[1]);
    this->led4->write(bits[0]);
    
    // don't overflow
    this->count = (this->count+1) % 16;

}