/**
 * Mostly just a wrapper around the LCD display.
 *
 * Author: Jacob Baungard Hansen
 */

#include "lcd_helper.h"

/**
 * Constructor setups the LCD Display
 * and writes initial values needed for this project.
 */
LCDHelper::LCDHelper() {

  this->par_port = new MCP23017(p9, p10, 0x40); // initialise 16-bit I/O chip
  this->lcd = new WattBob_TextLCD(par_port); // initialise 2*26 char display 
  par_port->write_bit(1,BL_BIT); // turn LCD backlight ON 
  
    lcd->cls(); // clear display
    
    this->print("Fr     d1   d2  ", "a1   a2   e  ");

}

LCDHelper::~LCDHelper() {
    delete this->par_port;
    delete this->lcd;
}

/**
 * Clears the display and prints one line
 */
void LCDHelper::print(std::string line1) {
    this->print(line1, std::string());
}

/**
 * Clears the display and prints two lines
 */
void LCDHelper::print(std::string line1, std::string line2) {
    lcd->cls(); // clear display
    
  lcd->locate(0,0); // set cursor to location (0,0) - top left corner
  lcd->printf(line1.c_str()); 
    
    // only print line2 if it contains data
    if (!line2.empty()) {
    lcd->locate(1,0); // set cursor to location (1,0) - bottom left corner
    lcd->printf(line2.c_str()); 
    }
}

void LCDHelper::clear() {
    lcd->cls(); // clear display
}

/**
 *
 *
 * @Param   state       pointer to state object
 */
void LCDHelper::print_state(State * state) {
    lcd->locate(0,3);
    lcd->printf("%d", state->get_freq());
    
    lcd->locate(0,10);
    lcd->printf("%d", state->get_digital_1());
    
    lcd->locate(0,15);
    lcd->printf("%d", state->get_digital_2());
    
    lcd->locate(1,3);
    // printf is very slow at converting from float to int
    int avg_analog_1 = (int) floor( state->get_avg_analog_1() + 0.5);
    lcd->printf("%d", avg_analog_1);
        
    lcd->locate(1,8);
    // printf is very slow at converting from float to int
    int avg_analog_2 = (int) floor( state->get_avg_analog_2() + 0.5);
  lcd->printf("%d", avg_analog_2);
    
    lcd->locate(1,12);
    lcd->printf("%d", state->get_error() );
    
}