/**
 * Main class for the project.
 * The main class instantiates all the tasks and schedules them
 * correctly using the TaskManager object.
 *
 * As writing to the SDCard occasionally hits +50ms in timing, there was several issue
 * with the schedule purposed in the original assignment. As a result the timings have changed.
 * 
 * Action 2 (reading digital values) have been discarded. The values are only used
 * in the Action 5, as a result we might as well read them "Just In Time". 
 * However if desired it could have been scheduled starting at 600ms with a freqency of 600ms
 * 
 * The schedule is as follows:
 * Action 1 (frequency)           1200ms
 * Action 2 (get digital input)   disabled, see above
 * Action 3 (read analog in)      600ms
 * Action 4 (Print to LCD)        1200ms
 * Action 5 (checks)              600ms
 * Action 5.1 (binary counting)   1800ms
 * Action 6 (SDCard)              4800ms
 *
 * Author: Jacob Baungard Hansen
 */

#include "task.h"
#include "lcd_helper.h"
#include "demo_task.h"
#include "task_manager.h"
#include "state.h"
#include "lcd_task.h"
#include "update_analog_task.h"
#include "check_task.h"
#include "freq_task.h"
#include "SDFileSystem.h"
#include "sdcard_task.h"

int main() {

    LCDHelper * lcd_helper = new LCDHelper();
    
    State * state = new State(); 
    
    TaskManager * tm = new TaskManager(100, lcd_helper);
    
    UpdateAnalogTask * analog_task  = new UpdateAnalogTask(100, 600, state);
    CheckTask * check_task = new CheckTask(200, 600, state, tm);
    FrequencyTask * freq_task = new FrequencyTask(300, 1200, state);
    LCDTask * lcd_task = new LCDTask(400, 2400, lcd_helper, state);
    SDCardTask * sd_task = new SDCardTask(4800, 4800, state);
    
    tm->add_task(check_task);
    tm->add_task(analog_task);
    tm->add_task(lcd_task);
    tm->add_task(freq_task);
    tm->add_task(sd_task);
    
    tm->start();
    
    delete lcd_helper;
    delete lcd_task;
    delete analog_task;
    delete freq_task;
    delete sd_task;
    delete tm;  

}