/************************************************************************************************
File name:          main.cpp
Description:        项目激光部分客户端代码
Author:             秦智
Date:               June 4, 2018
Others:             本程序编写在mbed平台(https://os.mbed.com/)上

*************************************************************************************************/

#include "mbed.h"
#include <math.h>
#include <cstring>
#include <stdlib.h>
#include "SDFileSystem.h"
#include "networking.h"
//#include <string>



#define edgex1 125         //          上x(正朝向开关)下y(负朝向开关)
#define edgex2 155        //              __
#define edgey1 70         //              ||
#define edgey2 100        //              125mm y2
#define widthx 30        //         x2   ||         x1
#define widthy 30        //      //=====210mm====//35mm/|开关
#define mm 100//100步1mm  //              ||
                          //              ||
                          //              ||
                          //              __       y1
                          //              
                          //              -- 开关   15mm


/////调试
Serial pc(PA_9, PA_10);
DigitalOut LED(PB_8);
/////

//硬件接口
// mosi, miso, sclk, cs, name
SDFileSystem sd(PB_15, PB_14, PB_13, PB_12, "sd");
//步进电机
DigitalOut step[2] = {DigitalOut(PC_5), DigitalOut(PA_5)}; //0--x P9,1--y P17
DigitalOut dir[2] = {DigitalOut(PC_4), DigitalOut(PA_4)}; //0--x,1--y
DigitalOut en[2] = {DigitalOut(PD_2), DigitalOut(PA_2)}; //0--x,1--y
//电子开关,激光开关
DigitalOut switch_GS(PC_15);
//行程开关
 DigitalIn switch_pos1(PC_8);   //P25
 DigitalIn switch_pos2(PA_6);  //P26
 DigitalIn switch_pos3(PA_11);  //P27

//运行中的全局变量
volatile bool Working, Getawork, Isend, Dataused, Getdata;
FILE *fp_drawing; // 存储图案的文件
int status = 0; //0: 初始化;  1:建立通信;  2:等候任务;  3:等待数据    4:正在执行一个任务
int now_x, now_y;
int Endoffile = 0;

// float thedata[50][3];
// char sdata[1024];
int Nofdata;
bool ifreceive;

//与实际有关参数
float Lenoflattice = 1 ;//mm  取1mm为xy单元  unit_xy/Lenoflattice=100
int unit_xy = 100;  //单位长度(xy移动一格)对应unit_xy转   大约10cm/3圈/9600step 约96mm/9600step=0.1mm/10step
int unit_x = 103;  //单位长度(xy移动一格)对应unit_x转   大约10cm/3圈/9600step 约96mm/9600step=0.1mm/10step
int unit_y = 103;  //单位长度(xy移动一格)对应unit_y转   大约10cm/3圈/9600step 约96mm/9600step=0.1mm/10step
///Ticker ticker_step;
float step_halfperiod = 0.0001;//0.0002;
int max_x, max_y;
int dir_x = 1;///调试时调整
int dir_y = 1;///调试时调整
int dot_max = 30;      //灰度最大值对应多少次激光点击
float dot_last = 0.005;    //每次激光点击持续多久
int H_max = 255;  //灰度值最大值
double k = 1.0; //缩放比例
double y=0;//图片y边长
double x=0;//图片x边长
int key=0;//判断变量
int dot=0;//点计数
int flag=0;
int numbers[100][3];
//char buf[100];


void rotate(int id ,int pix);



void biginning()
{
    pc.printf("x\n");           //          上x(正朝向开关)下y(负朝向开关)
    while(!switch_pos1.read())  //              __      y2
    {                           //              ||
    rotate(0,5);                //              115mm
    }                           //      x2      ||      x1                      
    rotate(0,-mm*edgex2);      //      //=====200mm====//42mm/|开关
    pc.printf("y\n");           //              ||
    while(!switch_pos2.read())  //              ||
    {                           //              ||
    rotate(1,-5);               //              __      y1
    }                           //
     rotate(1,mm*edgey1);      //              __ 开关   15mm
     //定位
    for (int i = 0; i < 500; i++) 
    {
        switch_GS = 1;
        wait(0.005);
        switch_GS = 0;
        wait(0.005);
    }
     //走轮廓
     rotate(0,mm*widthx);  
     rotate(1,mm*widthy);
     rotate(0,mm*-widthx);
     rotate(1,mm*-widthy);
}

void report()
{
    // ser2usb.printf("-1- status: %d \r\n", status);
    // ser2usb.printf("-2- now_x: %d now_y: %d \r\n", now_x,now_y);
    //ser2usb.printf("-3- switch_GS: %i \r\n", switch_GS.read());
    //ser2usb.printf("-4- switch_pos1: %i switch_pos2: %i switch_pos3: %i \r\n", switch_pos1.read(),switch_pos2.read(),switch_pos3.read());
    //ser2usb.printf("-5- en[0]: %i en[1]: %i \r\n", en[0].read(),en[1].read());
    //ser2usb.printf("-6- dir[0]: %i dir[1]: %i \r\n", dir[0].read(),dir[1].read());
    //ser2usb.printf("-7- step[0]: %i step[1]: %i \r\n", step[0].read(),step[1].read());
}

void init()
{
    status = 0;
    now_x = 0;
    now_y = 0;
    step[0] = 0;
    step[1] = 0;
    //memset(buf,0,sizeof(buf)/sizeof(char));
    //上x下y

}
void rotate(int id, int pix) //id= 0--x,1--y  pix=3200为一圈
{
    if (pix >= 0) {
        dir[0] = dir_x;
        dir[1] = dir_y;
    } else {
        pix = -pix;
        dir[0] = 1 - dir_x;
        dir[1] = 1 - dir_y;
    }
    for (int i = 0; i < pix; i++) {
        step[id] = 1;
        wait(step_halfperiod);
        step[id] = 0;
        wait(step_halfperiod);
    }
}

void moveto(float x, float y)
{
    rotate(0, (x - now_x)*unit_xy);
    rotate(1, (y - now_y)*unit_xy);
    now_x = x;
    now_y = y;
}
void fuwei()
{
    moveto(0, 0);
    status = 1;
}
void markdot(float value)
{
    //switch_GS=1;
    int Ndot = floor(value * dot_max / H_max);
    for (int i = 0; i < Ndot; i++) {
        switch_GS = 1;
        wait(dot_last);
        switch_GS = 0;
    }
}
/*
void dealdata(){
    ser2usb.printf("getdata: %s \r\n",sdata);
    int data_size = 0;//strlen(pch);
    char * pch;
    pch = strtok (sdata,"\r\n ,.-)(");
    while (pch != NULL)
    {
        thedata[data_size/3][data_size%3]=atof(pch);
        pch = strtok (NULL, "\r\n ,.-)(");
        data_size++;
    }
    Nofdata = (data_size)/3;
}
void usbprintdata(){
    ser2usb.printf("dealdata:  \r\n   <<<<<<<<<<<<<<<<");
    for(int i=0;i<Nofdata;i++){
        ser2usb.printf("<<< i: %i  x: %f  y: %f  v: %f \r\n",i,thedata[i][0],thedata[i][1],thedata[i][2]);
    }
    ser2usb.printf("dealdata done!    \r\n    >>>>>>>>>>>>");
}
*/

void str2numbers(char buf[])
{
    pc.printf("%s\r\n",buf);
    char *p = buf;
    int index = 0;
    int x,y,z;
    while(true)
    {
        p = strchr(p, '(');
        if(!p) break;
        p++;
        sscanf(p, "%d%d%d",&x,&y,&z);
        pc.printf("%d %d %d \r\n",x,y,z);
        numbers[index][0] = x;
        numbers[index][1] = y;
        numbers[index][2] = z;
        index++;
    }
}

void draw()
{
    unit_xy=unit_xy*k;
    float x, y, v;
    fp_drawing = fopen("/sd/write.txt", "r");
    pc.printf("reading\r\n");
    for (int i = 0; fscanf(fp_drawing, "(%f,%f,%f)", &x, &y, &v) == 3; i++) 
    {
        pc.printf("(%f,%f,%f)|%d|%d\r\n", x, y, v,i,dot);
        moveto(x, y);
        markdot(v);
        // moveto(thedata[i][0],thedata[i][1]);
        // markd??>ot(thedata[i][2]);
    }
    fclose(fp_drawing);
}

void on_control_cmd(const char* actuator_name, const char* control_value)
{
    //pc.printf("Received [%s] [%s]\r\n", actuator_name, control_value);
    if (strcmp(actuator_name, "dat") == 0) {
        //接受到的坐标数据写入存储卡
        /*
        if(dot<10)
        {
            strcpy(buf,control_value);
            dot++;
            pc.printf("received   %d|%d|%s\r\n",status,dot,buf);
        }
        else
        {
            fprintf(fp_drawing, "%s", buf);
            memset(buf,0,sizeof(buf)/sizeof(char));
            dot=0;
            strcpy(buf,control_value);
            dot++;
            flag=1;
            pc.printf("received.   %d|%d|%s\r\n",status,dot,buf);
        }
        */
        //fprintf(fp_drawing, "%s", control_value);
        //str2numbers(control_value);
        pc.printf("received   %d|%d\r\n",status,dot);
        fprintf(fp_drawing, "%s", control_value);
        dot++;
        flag=1;
        pc.printf("received   %d|%d\r\n",status,dot);
        
    } 
    else if (strcmp(actuator_name, "command") == 0) {
        int the_command = atoi(control_value);
        //
        if(key!=0)
            {
                if (key==1) {
                    k=the_command*0.1;
                    pc.printf("Received k %f\n",k);
            
                }
                if (key==2) {
                    x=the_command;
                    pc.printf("Received x %f\n",x);
            
                }
                if (key==3) {
                    y=the_command;
                    pc.printf("Received y %f\n",y);
                }

                key=0;
            }
        else
        {
                if (the_command == 1&&status==2&&key==0) {
                    Getawork = 1;
                } 
                if (the_command == 2&&status==3&&key==0) {
                    Getdata = 1;
                    pc.printf("Received Getdata %d\n",Getdata);
                }
                /*else if (the_command == 3&&status==2&&key==0) {//传k
                    key=1;
                }*/
                else if (the_command == 4&&status==2&&key==0) {//传x
                    key=2;
                }
                else if (the_command == 5&&status==2&&key==0) {//传y
                    key=3;
                }
        }
        //
        
    }
}

int main()
{
    init();     //初始化

    //建立通信
    status = 1;

    pc.printf("starting\r\n");

    MQTTSocket sock;
    MClient client(sock);

    //声明所有的传感器，每行一个，每个由名字、单位两部分组成，最后一行必须为空指针作为结尾
    const char* sensors[][2] = {
        "report", "",
        NULL, NULL //最后一行以空指针作为结束标记
    };

    //声明所有的执行器，每行一个，每个由名字、参数类型两部分组成，最后一行必须为空指针作为结尾
    const char* actuators[][2] = {
        "dat", "",
        "command", "",
        NULL, NULL //最后一行以空指针作为结束标记
    };
    pc.printf("connecting...\r\n");

    networking_init(sock, client, "192.168.1.100", sensors, actuators, on_control_cmd);

    pc.printf("Initialization done.\r\n");

    status = 2;

    
    pc.printf("laser printer send ready.haha\r\n");
    
    Getawork = 0;
    Getdata = 0;

    //pc.printf("yes%f|%f|%f\r\n",y,k,y*k);
    //pc.printf("ready.\r\n");
    
    
    pc.printf("biginning\r\n");
    biginning();
    pc.printf("finish\r\n");
    
    //draw();
    
    while (true) 
    {
        if(x==0||y==0&&status==2)
        {
            while(x==0&&status==2)
            {   
                pc.printf("waiting x\r\n");
                publish_value(client, "report", "input x:");
                client.yield(5000);
            }
            while(y==0&&status==2)
            {
                pc.printf("waiting y\r\n");
                publish_value(client, "report", "input y:");
                client.yield(5000);
            }
        }
        while(y*k>widthy&&status==2)
        {
            k-=0.01;
            pc.printf("no%f|%f|%f\r\n",y,k,y*k);
            wait(0.001);
        }
        if (status == 2) 
        {
            
            if (Getawork) 
            { //收到新任务
                Getawork = 0;
                pc.printf("Begin receiving...  %d\r\n",status);
                // 打开文件，准备接受坐标数据
                fp_drawing = fopen("/sd/write.txt", "w");
                if (fp_drawing) 
                {
                    pc.printf("File opened\r\n");
                    status = 3;
                    publish_value(client, "report", "wait data.");
                    pc.printf("wait data.%d\r\n",status);
                }
            }
            else
            {
                publish_value(client, "report", "ready.");
            }
             
        }

         
        if (status == 3) 
        {
            if(flag==1)
            {
                //wait(15);
                
                publish_value(client, "report", "received.");
                pc.printf("received.  %d\r\n",status);
                flag=0;
            }
            if (Getdata) 
            { //数据接收完
                Getdata = 0;
                /*
                fprintf(fp_drawing, "%s", buf);
                memset(buf,0,sizeof(buf)/sizeof(char));
                dot=0;
                */
                pc.printf("End receiving...  %d\r\n",status);
                fclose(fp_drawing);
                publish_value(client, "report", "starting");
                status = 4;
            }
        } 
        if (status == 4) 
        {
            // pc.printf("debug4 \r\n");
            // dealdata();
            pc.printf("Drawing..  %d |%d\r\n",status,dot);
            // usbprintdata();
            draw();
            publish_value(client, "report", "done.");
            pc.printf("done.  %d \r\n",status);
            
            status = 2;
            x=0;
            y=0;
            Getawork = 0;
            Getdata = 0;
            unit_xy=200;
            k=1.0;
            flag=0;
            dot=0;
            //memset(buf,0,sizeof(buf)/sizeof(char));
        }
        client.yield(1000);
    }
    
}
