#include <cstdarg>
#include <cstring>
#include "esp8266.h"
#include "mbed.h"



Serial ser2usb(PB_10, PB_11,115200);
DigitalOut red[2]=
{
    PB_13,PB_12,
};

DigitalOut black[3]=
{
    PA_12,PA_11,PB_3,
};

int state = 0;
int x[256];
int y=0;
bool ready,received,start,done;

void open(int row,int col);
void SetUp();


int main() 
{
    SetUp();
    //wait(2);

     

    ser2usb.printf("starting\r\n");
    
    // 选定与 esp8266 相连接的串口，WiFi 名称和密码
    Esp8266 client(PA_9, PA_10, "iot_b827eb8fb527", "7c02b50b");// 参数分别为 TX pin / RX pin / SSID / Password

    //声明所有的传感器，每行一个，每个由名字、单位两部分组成，最后一行必须为空指针作为结尾
    const char* sensors[][2] = {
        "", "",
        NULL, NULL //最后一行以空指针作为结束标记
    };

    //声明所有的执行器，每行一个，每个由名字、参数类型两部分组成，最后一行必须为空指针作为结尾
    const char* actuators[][2] = {
        "command", "",
        "dat", "",
        NULL, NULL //最后一行以空指针作为结束标记
    };
    ser2usb.printf("connecting...\r\n");

    //连接到服务器
    client.connect_mqtt_broker("192.168.12.1", "warehouse", sensors, actuators);

    client.subscribe_control(actuators[0][0]);
    client.subscribe_control(actuators[1][0]);
    
    ser2usb.printf("Initialization done.\r\n");
    char actuator_name[32], control_value[32];
    Timer t;// 定时器用于计量发送传感器数据的时间
    t.start();
    //client.publish_value("report", "carinit");
        
        
        
    while(1) 
    {
        
        //检查有没有收到新的执行器控制指令
        if(client.get_control_cmd(actuator_name, control_value))
        {
            ser2usb.printf("Received %s %s\r\n", actuator_name, control_value);
            if (strcmp(actuator_name, "command") == 0) 
            {
                ser2usb.printf("Received CMD %s %s\r\n", actuator_name, control_value);
                int the_command = atoi(control_value);
                //
                if(the_command==1)
                {
                    ready=1;
                    ser2usb.printf("get ready\r\n");
                }
                else if(the_command==2)
                {
                    start=1;
                    ser2usb.printf("get start\r\n");
                }
                else if(the_command==3)
                {
                    done=1;
                    ser2usb.printf("get done\r\n");
                }
                //
        
            }
            else if (strcmp(actuator_name, "dat") == 0)
            {
                int the_command = atoi(control_value);
                received=1;
                ser2usb.printf("received \r\n");
                x[y]=the_command;
                y++;
                ser2usb.printf("get %s|%d\r\n",control_value,y);
                client.publish_value("report", "received.");
                /*
                else
                {
                    //received=1;
                    //client.publish_value("report", "received.");
                    x[y]=the_command;
                    y++;
                    ser2usb.printf("get %s|%d\r\n",control_value,y);
                }
                */
            }
            /*
            ser2usb.printf("Received CMD %s %s\r\n", actuator_name, control_value);
            //判断哪个执行器收到命令
            state = atoi(control_value);
            switch(state)
            {
                case 1:
                    open(0,0);
                    client.publish_value("report", "opened");
                    break;
                case 2:
                    open(0,1);
                    client.publish_value("report", "opened");
                    break;
                case 3:
                    open(0,2);
                    client.publish_value("report", "opened");
                    break;
                case 4:
                    open(1,0);
                    client.publish_value("report", "opened");
                    break;
                case 5:
                    open(1,1);
                    client.publish_value("report", "opened");
                    break;
                case 6:
                    open(1,2);
                    client.publish_value("report", "opened");
                    default:
                    break;
               }
           }
           */  
        }
        
        if(!ready)
        {
            client.publish_value( "report", "ready.");
            //ser2usb.printf("send ready.%d\r\n",flagw);
            ser2usb.printf("ready?\r\n");
            
        }
        if(!start&&ready&&!received)
        {
            ser2usb.printf("send start.\r\n");
            client.publish_value("report", "wait data.");
        }
        if(start)
        {
            ser2usb.printf("starting\r\n");
            for(int i=0;x[i];i++)
            {
                state = x[i];
                //state = y;
                ser2usb.printf("starting %d\r\n",state);
                switch(state)
                {
                    case 1:
                        open(0,0);
                        //client.publish_value("report", "opened");
                        break;
                    case 2:
                        open(0,1);
                        //client.publish_value("report", "opened");
                        break;
                    case 3:
                        open(0,2);
                        //client.publish_value("report", "opened");
                        break;
                    case 4:
                        open(1,0);
                        //client.publish_value("report", "opened");
                        break;
                    case 5:
                        open(1,1);
                        //client.publish_value("report", "opened");
                        break;
                    case 6:
                        open(1,2);
                        //client.publish_value("report", "opened");
                    default:
                        break;
               }
            }
            client.publish_value("report", "done.");
            memset(x,0,sizeof(x));
            y=0;
            ready=0;
            received=0;
            start=0;
            done=0;
        }
    wait(0.01);   
    }                 
}

void SetUp()
{
    for(int i=0; i<2; i++)
    {
        red[i].write(0);
    }
    
    for(int i=0; i<3; i++)
    {
        black[i].write(0);
    }

}
void open(int row,int col)
{
        red[row].write(1);
        black[col].write(1);
        wait(0.2);
        SetUp();  
}
          
