#include "sensors.h"
#include "mbed.h"

extern Serial usb2pc;  
extern DigitalOut myled;
//============================================================
void sr501::triggered()                                     //触发中断!!
{
    usb2pc.printf("sr501 Triggered!\r\n");
    status = true;
}
//--------
sr501::sr501(PinName pSignal)                               //启动热释电!!!
    : status(false), signal(pSignal)
{
    signal.rise(this, &sr501::triggered);
    usb2pc.printf("sr501 start!\r\n");
}
//-------
bool sr501::operator==(const bool &target)
{
    if(status == target)
    {
        return true;
    }
    else
    {
        return false;
    }
}
//-------
void sr501::reset()
{
    status = false;
}
//-------
int sr501::read()
{
    return signal.read();
}
//==========================================
BH1750::BH1750(PinName sda,PinName scl)                     //启动光强!!!!!(默认设置)
    :link(sda,scl)                   
{
    status = true;
    char mode[1]={BH1750_CONTINUOUS_HIGH_RES_MODE};
    //usb2pc.printf("modifying\r\n");
    while(status)
    {
        status = link.write(BH1750_I2CADDR, mode, sizeof(mode), false);
        wait_ms(10);
    }
    usb2pc.printf("BH1750 start with default mode!\r\n");
}
//--------
BH1750::BH1750(PinName sda,PinName scl,char mode[])           //启动光强!!!!!(自定义设置)
    :link(sda,scl)         
{
    status = true;
    while(status)
    {
        status = link.write(BH1750_I2CADDR, mode, sizeof(mode), false);
        wait_ms(10);
    }
    usb2pc.printf("BH1750 start with customize mode!\r\n");    
}
//--------
float BH1750::getlightdata()                                //读取光强(lux)
{
    status = true;
    status = link.read(BH1750_I2CADDR, rawdata, 2, false);
    if(!status)
    {
        float result = ((rawdata[0]<<8)|rawdata[1])/1.2;
        return result;
    }
    else
    {
        usb2pc.printf("BH1750 read fail!\r\n");
        return -1;
    }
}
//==============================================
mq::mq(PinName dio)
    : status(false), signal(dio),signallevel(PC_13)
{
    signal.fall(this, &mq::triggered);
    usb2pc.printf("mq start!\r\n");
}
//--------
mq::mq(PinName dio,PinName aio)
    : status(false), signal(dio),signallevel(aio)
{
    signal.fall(this, &mq::triggered);
    usb2pc.printf("mq start!\r\n");
}
//--------
void mq::triggered()                                     //触发中断!!
{
    usb2pc.printf("mq Triggered!\r\n");
    status = true;
}
//--------
bool mq::operator==(const bool &target)
{
    if(status == target)
    {
        return true;
    }
    else
    {
        return false;
    }
}
//--------
float mq::getairdata()
{
    return signallevel.read();
}  
//-----------
void mq::reset()
{
    status = false;
}
int mq::read()
{
    return signal.read();
}
//===========================================
dht11::dht11(PinName pin)
    :datapin(pin)
{
    starttime.start();
    usb2pc.printf("dht11 start!\r\n");
}
//----------
int dht11::getdata()
{
    int timeout=10000;
    uint8_t data[5];
    uint8_t bit=7;
    uint8_t count=0;
        
    for(int i=0;i<5;i++)
    {
        data[i]=0;
    }
    if(starttime.read_ms()<1500){while(starttime.read_ms()<1500){}starttime.stop();}
        
    datapin.output();
    datapin=0;
    wait_ms(19);
    datapin=1;
    wait_us(30);
    datapin.input();
        
    while(!datapin)
    {
        if(timeout--==0){usb2pc.printf("timeout!no reset\r\n");return 0;}
    }
    timeout=10000;
    while(datapin)
    {
        if(timeout--==0){usb2pc.printf("timeout!no respanse\r\n");return 0;}
    }
    timeout=10000;
    for(int i=0;i<40;i++)
    {
        while(!datapin)
        {
            if(timeout--==0){usb2pc.printf("timeout!\r\n");return 0;}
        }
        timer.start();
        timeout=10000;
        while(datapin)
        {
            if(timeout--==0){usb2pc.printf("timeout!n\r\n");return 0;}
        }
        timeout=10000;
        long t=timer.read_us();
        timer.stop();
        timer.reset();
            
        if(bit==0)
        {
            if(t>40){data[count]|=(1<<bit);}
            bit=7;
            count++;
        }
        else
        {
            if(t>40)
            {
                data[count]|=(1<<bit);
            }
            bit--;
        }
    }
    datapin=1;
    if(data[4]==data[0]+data[1]+data[2]+data[3])
    {
        //usb2pc.printf("Humidity (%):%f\r\n",(float)data[0]);
        //usb2pc.printf("Temperature (oC): %f\r\n",(float)data[2]);
        H=data[0]+data[1]/10.0;
        T=data[2]+data[3]/10.0;
        return 1;
    }
    else{usb2pc.printf("error!\r\ndata0:%d\tdata1:%d\r\ndata2:%d\tdata3:%d\r\ndata4:%d\r\n",(int)data[0],(int)data[1],(int)data[2],(int)data[3],(int)data[4]);return 0;}
}  
//-------
float dht11::gethumidity()
{
    return H;
}
//-------
float dht11::gettemperature()
{
    return T;
}