#include "sensors.h"
#include "mbed.h"

extern Serial usb2pc;  
extern DigitalOut myled;
//============================================================
void sr501::triggered()                                     //触发中断!!
{
    usb2pc.printf("sr501 Triggered!\r\n");
    status = true;
}
//--------
sr501::sr501(PinName pSignal)                               //启动热释电!!!
    : status(false), signal1(pSignal),signal2(pSignal)
{
    signal1.rise(this, &sr501::triggered);
    usb2pc.printf("sr501 start!\r\n");
}
//-------
bool sr501::operator==(const bool &target)
{
    if(status == target)
    {
        return true;
    }
    else
    {
        return false;
    }
}
//-------
void sr501::reset()
{
    status = false;
}
//-------
int sr501::read()
{
    return signal2.read();
}
//==========================================
BH1750::BH1750(PinName sda,PinName scl)                     //启动光强!!!!!(默认设置)
    :link(sda,scl)                   
{
    status = true;
    char mode[1]={BH1750_CONTINUOUS_HIGH_RES_MODE};
    usb2pc.printf("modify\r\n");
    while(status)
    {
        status = link.write(BH1750_I2CADDR, mode, sizeof(mode), false);
        wait_ms(10);
    }
    usb2pc.printf("BH1750 start with default mode!\r\n");
}
//--------
BH1750::BH1750(PinName sda,PinName scl,char mode[])           //启动光强!!!!!(自定义设置)
    :link(sda,scl)         
{
    status = true;
    while(status)
    {
        status = link.write(BH1750_I2CADDR, mode, sizeof(mode), false);
        wait_ms(10);
    }
    usb2pc.printf("BH1750 start with customize mode!\r\n");    
}
//--------
float BH1750::getlightdata()                                //读取光强(lux)
{
    status = true;
    status = link.read(BH1750_I2CADDR, rawdata, 2, false);
    if(!status)
    {
        float result = ((rawdata[0]<<8)|rawdata[1])/1.2;
        return result;
    }
    else
    {
        usb2pc.printf("BH1750 read fail!\r\n");
        return -1;
    }
}