#ifndef SENSORS_H
#define SENSORS_H

#include "mbed.h"
//+++++++++++++++++++++BH1750+++++++++++++++++++++++++++++
#define BH1750_I2CADDR 0x46
#define BH1750_POWER_DOWN 0x00                  // No active state
#define BH1750_POWER_ON 0x01                    // Wating for measurment command
#define BH1750_RESET 0x07                       // Reset data register value - not accepted in POWER_DOWN mode
#define BH1750_CONTINUOUS_HIGH_RES_MODE  0x10   // Start measurement at 1lx resolution. Measurement time is approx 120ms.
#define BH1750_CONTINUOUS_HIGH_RES_MODE_2  0x11 // Start measurement at 0.5lx resolution. Measurement time is approx 120ms.
#define BH1750_CONTINUOUS_LOW_RES_MODE  0x13    // Start measurement at 4lx resolution. Measurement time is approx 16ms.

// Start measurement at 1lx resolution. Measurement time is approx 120ms.
// Device is automatically set to Power Down after measurement.
#define BH1750_ONE_TIME_HIGH_RES_MODE  0x20

// Start measurement at 0.5lx resolution. Measurement time is approx 120ms.
// Device is automatically set to Power Down after measurement.
#define BH1750_ONE_TIME_HIGH_RES_MODE_2  0x21

// Start measurement at 1lx resolution. Measurement time is approx 120ms.
// Device is automatically set to Power Down after measurement.
#define BH1750_ONE_TIME_LOW_RES_MODE  0x23
//++++++++++++++++++++++++++++++++++++++++


class sr501
{
/*****
 * 红外热释电对象
 * 感应输出高电平
*****/
  private:
//    DigitalIn signal;
    bool status;
    InterruptIn signal1;
    DigitalIn signal2;
    void triggered();
  public:
    sr501(PinName pSignal);
    bool operator==(const bool &target);
    void reset();
    int read();
};
//=========================================
class BH1750
{
    
/*****

*****/
  private:
    I2C link;
    char rawdata[2];
    bool status;
  public:
    BH1750(PinName sda,PinName scl);
    BH1750(PinName sda,PinName scl,char mode[]);
    float getlightdata();
};
#endif
