/*-----------------------------------------------------
 File Name : main.cpp
 Purpose : For esp8266 mbed porting
 Creation Date : 22-06-2017
 Last Modified :
 Created By : Jeasine Ma [jeasinema[at]gmail[dot]com]
-----------------------------------------------------*/
#include <cstdarg>
#include <cstring>
#include "mbed.h"
#include "esp8266.h"

Serial ser2usb(PA_2, PA_3, 115200);  
//DigitalIn ref(PA_12);
DigitalOut LED(PC_13);
DigitalOut IN1(PB_0);
DigitalOut IN2(PB_1);
DigitalOut IN3(PB_10);
DigitalOut IN4(PB_11);
//PwmOut ENA(PB_1);
//PwmOut ENB(PB_0);
//InterruptIn switch1(PB_6);
int state = 0;
int x[256];
int y=0;
bool ready,received,start,done;

void run_forwoard();
void run_backwoard();
void turn_left();
void turn_right();
void stop();
void init();
void after_irq();

int main(void) {
    for(int i =0;i<4;i++)
    {
    	LED=1;
    	wait(1.0);
    	LED=0;
    	wait(1.0);
    }
    IN1 = 0;
    IN2 = 0;
    IN3 = 0;
    IN4 = 0;
   // ENA.period_ms(10);
  //  ENB.period_ms(10);
   // ENA.pulsewidth_ms(5);
   // ENB.pulsewidth_ms(5);
	
	
    ser2usb.printf("starting\r\n");
    
    // 选定与 esp8266 相连接的串口，WiFi 名称和密码
    Esp8266 client(PA_9, PA_10, "iot_b827eb8fb527", "7c02b50b");// 参数分别为 TX pin / RX pin / SSID / Password//"iot_b827eb8fb527", "7c02b50b"

    //声明所有的传感器，每行一个，每个由名字、单位两部分组成，最后一行必须为空指针作为结尾
    const char* sensors[][2] = {
        "report", "",
        NULL, NULL //最后一行以空指针作为结束标记
    };

    //声明所有的执行器，每行一个，每个由名字、参数类型两部分组成，最后一行必须为空指针作为结尾
    const char* actuators[][2] = {
        "command", "int",
        "dat", "int",
        NULL, NULL //最后一行以空指针作为结束标记
    };
    ser2usb.printf("connecting...\r\n");

    //连接到服务器
    client.connect_mqtt_broker("192.168.12.1", "car", sensors, actuators);

    ser2usb.printf("Initialization done.\r\n");
    char actuator_name[32], control_value[32];
    Timer t;// 定时器用于计量发送传感器数据的时间
    t.start();
		//client.publish_value("sudo", "carinit");
    while(1) 
    {
        //检查有没有收到新的执行器控制指令
        if(client.get_control_cmd(actuator_name, control_value))
        {
            ser2usb.printf("Received %s %s\r\n", actuator_name, control_value);
            if (strcmp(actuator_name, "command") == 0) 
            {
                ser2usb.printf("Received CMD %s %s\r\n", actuator_name, control_value);
                int the_command = atoi(control_value);
                //
                if(the_command==1)
                {
                    ready=1;
                    ser2usb.printf("get ready\r\n");
                }
                else if(the_command==2)
                {
                    start=1;
                    ser2usb.printf("get start\r\n");
                }
                else if(the_command==3)
                {
                    done=1;
                    ser2usb.printf("get done\r\n");
                }
                //
        
            }
            else if (strcmp(actuator_name, "dat") == 0)
            {
                int the_command = atoi(control_value);
                received=1;
                ser2usb.printf("received \r\n");
                x[y]=the_command;
                y++;
                ser2usb.printf("get %s|%d\r\n",control_value,y);
                client.publish_value("report", "received.");
                client.publish_value("report", " ");
                /*
                else
                {
                    //received=1;
                    //client.publish_value("report", "received.");
                    x[y]=the_command;
                    y++;
                    ser2usb.printf("get %s|%d\r\n",control_value,y);
                }
                */
            }
        }
        if(!ready)
        {
            client.publish_value( "report", "ready.");
            //ser2usb.printf("send ready.%d\r\n",flagw);
            ser2usb.printf("ready?\r\n");
            
        }
        if(!start&&ready&&!received)
        {
            ser2usb.printf("send start.\r\n");
            client.publish_value("report", "wait data.");
        }
        if(start)
        {
            ser2usb.printf("starting\r\n");
            for(int i=0;x[i];i++)
            {
                state = x[i];
                //state = y;
                ser2usb.printf("starting %d\r\n",state);
                switch(state)
                {
                	case 1:  // white to black
                    	run_forwoard();
                    	wait(1);
                    	stop();
						//client.publish_value("sudo", "carfinish");
                    	break;
                    
                	case 2:
                		run_backwoard();
                		wait(1);
                    	stop();
						//client.publish_value("sudo", "carfinish");
                    	break;
                    	
                    case 3:
                		turn_left();
                		wait(1);
                    	stop();
						//client.publish_value("sudo", "carfinish");
                    	break;
                    	
                    case 4:
                		turn_right();
                		wait(1);
                    	stop();
						//client.publish_value("sudo", "carfinish");
                    	break;
                    
                	default:
                    	break;
               }
            }
            client.publish_value("report", "done.");
            memset(x,0,sizeof(x));
            y=0;
            ready=0;
            received=0;
            start=0;
            done=0;
        }
            /*
            ser2usb.printf("Received CMD %s %s\r\n", actuator_name, control_value);
            //判断哪个执行器收到命令
            state = atoi(control_value);
            switch (state)
            {
                case 1:  // white to black
                    run_forwoard();
                    wait(1);
                    stop();
					client.publish_value("sudo", "carfinish");
                    break;
                    
                case 2:
                	run_backwoard();
                	wait(1);
                    stop();
					client.publish_value("sudo", "carfinish");
                    break;
                    
                default:
                    break;
                
            }
            */
        wait(0.1);    
        
    }
}


void run_forwoard()
{     IN1 = 1;
      IN2 = 0;
      IN3 = 1;
      IN4 = 0;
}

void run_backwoard()
{
    IN1 = 0;
    IN2 = 1;
    IN3 = 0;
    IN4 = 1;
}

void turn_left()
{
    IN1 = 0;
    IN2 = 1;
    IN3 = 1;
    IN4 = 0;
}
void turn_right()
{
    IN1 = 1;
    IN2 = 0;
    IN3 = 0;
    IN4 = 1;
}

void stop()
{
    IN1 = 0;
    IN2 = 0;
    IN3 = 0;
    IN4 = 0;
}
