#include <cstdarg>
#include <cstring>
#include "esp8266.h"
#include "mbed.h"



Serial ser2usb(PA_2, PA_3, 115200);
int state = 0;
void open(int row,int col);
void SetUp();

DigitalOut red[2]=
{
    PB_13,PB_12,
};

DigitalOut black[3]=
{
    PA_12,PA_11,PB_3,
};


int main() 
{
    SetUp();
    wait(2);

     


//ser2usb.printf("starting\r\n");
    
    // 选定与 esp8266 相连接的串口，WiFi 名称和密码
    Esp8266 client(PA_9, PA_10, "iot_b827eb8fb527", "7c02b50b");// 参数分别为 TX pin / RX pin / SSID / Password

    //声明所有的传感器，每行一个，每个由名字、单位两部分组成，最后一行必须为空指针作为结尾
    const char* sensors[][2] = {
        "actionok", "",
        NULL, NULL //最后一行以空指针作为结束标记
    };

    //声明所有的执行器，每行一个，每个由名字、参数类型两部分组成，最后一行必须为空指针作为结尾
    const char* actuators[][2] = {
        "do", "int",
        NULL, NULL //最后一行以空指针作为结束标记
    };
    //ser2usb.printf("connecting...\r\n");

    //连接到服务器
    client.connect_mqtt_broker("192.168.12.1", "car", sensors, actuators);

    ser2usb.printf("Initialization done.\r\n");
    char actuator_name[32], control_value[32];
    Timer t;// 定时器用于计量发送传感器数据的时间
    t.start();
        client.publish_value("do", "carinit");
        
    while(1) 
    {
        //检查有没有收到新的执行器控制指令
        if(client.get_control_cmd(actuator_name, control_value))
        {
            ser2usb.printf("Received CMD %s %s\r\n", actuator_name, control_value);
            //判断哪个执行器收到命令
            state = atoi(control_value);
            switch(state)
            {
                case 1:
                    open(0,0);
                    client.publish_value("do", "carfinish");
                    break;
                case 2:
                    open(0,1);
                    client.publish_value("do", "carfinish");
                    break;
                case 3:
                    open(0,2);
                    client.publish_value("do", "carfinish");
                    break;
                case 4:
                    open(1,0);
                    client.publish_value("do", "carfinish");
                    break;
                case 5:
                    open(1,1);
                    client.publish_value("do", "carfinish");
                    break;
                case 6:
                    open(1,2);
                    client.publish_value("do", "carfinish");
                    default:
                    break;
               }
           } 
        }
        
        
                
}

void SetUp()
{
    for(int i=0; i<2; i++)
    {
        red[i].write(0);
    }
    
    for(int i=0; i<3; i++)
    {
        black[i].write(0);
    }
    

}
void open(int row,int col)
{
        red[row].write(1);
        black[col].write(1);
        wait(0.2);
        SetUp();  
}
          
